/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.matlab.MatlabActionParserException;
import eu.cqse.check.matlab.SymbolConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import org.conqat.lib.commons.enums.EnumUtils;

public class MatlabActionScanner
implements Scanner {
    private static final int UNKNOWN_SYMBOL = -1;
    private static final Map<ETokenType, Integer> TOKEN_TO_SYMBOL_IDS = MatlabActionScanner.determineTokenToSymbolIndexMap();
    private List<IToken> tokens;
    private int index = 0;

    public MatlabActionScanner(List<IToken> tokens) {
        this.tokens = new ArrayList<IToken>(tokens);
        this.tokens = TokenStreamUtils.removeAtFront(this.tokens, ETokenType.EOL);
        if (!this.tokens.isEmpty() && !TokenStreamUtils.endsWith(this.tokens, ETokenType.EOL)) {
            this.tokens.add(TokenStreamUtils.createToken(tokens.get(tokens.size() - 1), "\n", ETokenType.EOL));
        }
    }

    public Symbol next_token() throws Exception {
        if (this.index >= this.tokens.size()) {
            return new Symbol(0);
        }
        IToken token = this.tokens.get(this.index);
        int symbolId = TOKEN_TO_SYMBOL_IDS.getOrDefault(token.getType(), -1);
        if (symbolId == -1) {
            throw new MatlabActionParserException("Unknown symbol " + String.valueOf(token.getType()));
        }
        Symbol symbol = this.index == 0 ? new Symbol(symbolId, this.index, this.index + 1, (Object)token) : (this.index == this.tokens.size() - 1 ? new Symbol(symbolId, this.index - 1, this.index, (Object)token) : new Symbol(symbolId, this.index - 1, this.index + 1, (Object)token));
        ++this.index;
        return symbol;
    }

    private static Map<ETokenType, Integer> determineTokenToSymbolIndexMap() {
        HashMap<ETokenType, Integer> tokenToSymbolIndexMap = new HashMap<ETokenType, Integer>();
        for (int i = 0; i < SymbolConstants.terminalNames.length; ++i) {
            String terminalName = SymbolConstants.terminalNames[i];
            ETokenType tokenType = (ETokenType)EnumUtils.valueOf(ETokenType.class, (String)terminalName);
            if (tokenType == null) continue;
            tokenToSymbolIndexMap.put(tokenType, i);
        }
        return tokenToSymbolIndexMap;
    }
}

