/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.php.cache.CpdDeserializationInput;
import org.sonar.php.cache.StringTable;
import org.sonar.php.cache.VarLengthInputStream;
import org.sonar.php.metrics.CpdVisitor;

public class CpdDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(CpdDeserializer.class);
    private final VarLengthInputStream in;
    private final VarLengthInputStream stringTableIn;
    private final String pluginVersion;
    private StringTable stringTable;

    private CpdDeserializer(VarLengthInputStream in, VarLengthInputStream stringTableIn, String pluginVersion) {
        this.in = in;
        this.stringTableIn = stringTableIn;
        this.pluginVersion = pluginVersion;
    }

    @CheckForNull
    public static List<CpdVisitor.CpdToken> fromBinary(CpdDeserializationInput input) {
        CpdDeserializer deserializer = new CpdDeserializer(new VarLengthInputStream(input.cpdTokensBytes()), new VarLengthInputStream(input.stringTable()), input.pluginVersion());
        return deserializer.convert();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private List<CpdVisitor.CpdToken> convert() {
        try (VarLengthInputStream varLengthInputStream = this.in;){
            ArrayList<CpdVisitor.CpdToken> arrayList;
            block20: {
                VarLengthInputStream varLengthInputStream2;
                block18: {
                    List<CpdVisitor.CpdToken> list;
                    block19: {
                        varLengthInputStream2 = this.stringTableIn;
                        this.stringTable = this.readStringTable();
                        String pluginVersionText = this.readString();
                        if (pluginVersionText.equals(this.pluginVersion)) break block18;
                        list = null;
                        if (varLengthInputStream2 == null) break block19;
                        varLengthInputStream2.close();
                    }
                    return list;
                }
                try {
                    int sizeOfCpdTokens = this.readInt();
                    ArrayList<CpdVisitor.CpdToken> cpdTokens = new ArrayList<CpdVisitor.CpdToken>(sizeOfCpdTokens);
                    for (int i = 0; i < sizeOfCpdTokens; ++i) {
                        this.readCpdToken(cpdTokens);
                    }
                    if (!"END".equals(this.in.readUTF())) {
                        throw new IOException("Can't read data from cache, format corrupted");
                    }
                    arrayList = cpdTokens;
                    if (varLengthInputStream2 == null) break block20;
                }
                catch (Throwable throwable) {
                    if (varLengthInputStream2 != null) {
                        try {
                            varLengthInputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                varLengthInputStream2.close();
            }
            return arrayList;
        }
        catch (IOException e) {
            LOG.debug("Can't deserialize data from the cache", e);
            return null;
        }
    }

    private void readCpdToken(List<CpdVisitor.CpdToken> cpdTokens) throws IOException {
        cpdTokens.add(new CpdVisitor.CpdToken(this.readInt(), this.readInt(), this.readInt(), this.readInt(), this.readString()));
    }

    private int readInt() throws IOException {
        return this.in.readInt();
    }

    private String readString() throws IOException {
        return this.stringTable.getString(this.in.readInt());
    }

    private StringTable readStringTable() throws IOException {
        int size = this.stringTableIn.readInt();
        ArrayList<String> byIndex = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            byIndex.add(this.stringTableIn.readUTF());
        }
        if (!"END".equals(this.stringTableIn.readUTF())) {
            throw new IOException("Can't read data from cache, format corrupted");
        }
        return new StringTable(byIndex);
    }
}

