/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.metrics.CognitiveComplexityVisitor;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S3776")
public class FunctionCognitiveComplexityCheck
extends PHPVisitorCheck {
    public static final String KEY = "S3776";
    private static final String MESSAGE = "Refactor this function to reduce its Cognitive Complexity from %s to the %s allowed.";
    public static final int DEFAULT = 15;
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkFunctionComplexity(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkFunctionComplexity(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkFunctionComplexity(tree);
    }

    private void checkFunctionComplexity(FunctionTree functionTree) {
        CognitiveComplexityVisitor.CognitiveComplexity complexity = CognitiveComplexityVisitor.complexity(functionTree);
        if (complexity.getValue() > this.threshold) {
            String message = String.format(MESSAGE, complexity.getValue(), this.threshold);
            int cost = complexity.getValue() - this.threshold;
            PreciseIssue issue = this.context().newIssue(this, functionTree.functionToken(), message).cost(cost);
            complexity.getComplexityComponents().forEach(complexityComponent -> issue.secondary(complexityComponent.tree(), FunctionCognitiveComplexityCheck.secondaryMessage(complexityComponent.addedComplexity())));
        }
    }

    private static String secondaryMessage(int complexity) {
        if (complexity == 1) {
            return "+1";
        }
        return String.format("+%s (incl. %s for nesting)", complexity, complexity - 1);
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

