/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.php.checks.IgnoredReturnValueCheck;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.cfg.CfgBranchingBlock;
import org.sonar.plugins.php.api.cfg.ControlFlowGraph;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S836")
public class UseOfUninitializedVariableCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Review the data-flow - use of uninitialized value.";
    private static final Set<Tree.Kind> PARENT_INITIALIZATION_KIND = EnumSet.of(Tree.Kind.PARAMETER, new Tree.Kind[]{Tree.Kind.GLOBAL_STATEMENT, Tree.Kind.VARIABLE_DECLARATION, Tree.Kind.REFERENCE_VARIABLE, Tree.Kind.ARRAY_ASSIGNMENT_PATTERN_ELEMENT, Tree.Kind.UNSET_VARIABLE_STATEMENT, Tree.Kind.CATCH_BLOCK, Tree.Kind.ASSIGNMENT_BY_REFERENCE});
    private static final Set<String> FUNCTION_CHANGING_CURRENT_SCOPE = Set.of("eval", "extract", "parse_str", "preg_replace", "include", "include_once", "require", "require_once");
    private static final Set<String> PREDEFINED_VARIABLES = Set.of("$_COOKIE", "$_ENV", "$_FILES", "$_GET", "$_POST", "$_REQUEST", "$_SERVER", "$_SESSION", "$GLOBALS", "$HTTP_RAW_POST_DATA", "$HTTP_RESPONSE_HEADER", "$PHP_ERRORMSG", "$THIS");
    private static final Set<String> FUNCTION_ALLOWING_ARGUMENT_CHECK = new HashSet<String>(IgnoredReturnValueCheck.PURE_FUNCTIONS);
    private static final Map<Tree.Kind, Predicate<Tree>> IS_READ_ACCESS_BY_PARENT_KIND;

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkFunction(tree);
        super.visitFunctionDeclaration(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkFunction(tree);
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkFunction(tree);
        super.visitFunctionExpression(tree);
    }

    private void checkFunction(FunctionTree tree) {
        ControlFlowGraph cfg = ControlFlowGraph.build(tree, this.context());
        if (cfg == null) {
            return;
        }
        Set<CfgBlock> cfgBlocks = UseOfUninitializedVariableCheck.getReachableBlocks(cfg);
        HashMap blockSummaries = new HashMap();
        cfgBlocks.forEach(b -> blockSummaries.put(b, UseOfUninitializedVariableCheck.getBlockSummary(b)));
        Set<String> providedVariables = UseOfUninitializedVariableCheck.getParameterVariableNames(tree);
        if (tree.is(Tree.Kind.FUNCTION_EXPRESSION)) {
            providedVariables.addAll(UseOfUninitializedVariableCheck.getLexicalVariableNames((FunctionExpressionTree)tree));
        }
        InitialDataCollector initialDataCollector = new InitialDataCollector();
        tree.accept(initialDataCollector);
        providedVariables.addAll(initialDataCollector.exceptionVariables);
        ((BlockSummary)blockSummaries.get((Object)cfg.start())).stateOnBlockStart.initializedVariables.addAll(providedVariables);
        ArrayDeque<CfgBlock> workList = new ArrayDeque<CfgBlock>(cfgBlocks);
        while (!workList.isEmpty()) {
            CfgBlock block = (CfgBlock)workList.pop();
            BlockSummary summary = (BlockSummary)blockSummaries.get(block);
            for (CfgBlock successor : block.successors()) {
                StateOnBlockStart stateOnBlockStart = ((BlockSummary)blockSummaries.get((Object)successor)).stateOnBlockStart;
                if (stateOnBlockStart.containsBlockSummary(summary)) continue;
                stateOnBlockStart.addBlockSummary(summary);
                workList.add(successor);
            }
        }
        HashMap uninitializedVariableUses = new HashMap();
        cfgBlocks.forEach(b -> UseOfUninitializedVariableCheck.checkBlock(b, (BlockSummary)blockSummaries.get(b)).forEach((v, s) -> uninitializedVariableUses.computeIfAbsent(v, st -> new HashSet()).addAll(s)));
        uninitializedVariableUses.entrySet().stream().filter(e -> !UseOfUninitializedVariableCheck.isInitializedStaticVariable((String)e.getKey(), initialDataCollector.uninitializedStaticVariables, (BlockSummary)blockSummaries.get(cfg.end()))).forEach(e -> this.reportOnFirstTree((Set)e.getValue()));
    }

    private static boolean isInitializedStaticVariable(String var, Set<String> uninitializedStaticVariables, BlockSummary endBlockSummary) {
        return uninitializedStaticVariables.contains(var) && endBlockSummary.stateOnBlockStart.wasInitialized(var);
    }

    private void reportOnFirstTree(Set<Tree> trees) {
        trees.stream().min(Comparator.comparingInt(a -> ((PHPTree)a).getFirstToken().line()).thenComparing(a -> ((PHPTree)a).getFirstToken().column())).ifPresent(t -> this.newIssue((Tree)t, MESSAGE));
    }

    private static Set<CfgBlock> getReachableBlocks(ControlFlowGraph cfg) {
        HashSet<CfgBlock> result = new HashSet<CfgBlock>();
        result.add(cfg.start());
        ArrayDeque workList = new ArrayDeque(result);
        while (!workList.isEmpty()) {
            CfgBlock item = (CfgBlock)workList.pop();
            Set newSuccessors = item.successors().stream().filter(b -> !result.contains(b)).collect(Collectors.toSet());
            result.addAll(newSuccessors);
            workList.addAll(newSuccessors);
        }
        return result;
    }

    private static Map<String, Set<Tree>> checkBlock(CfgBlock block, BlockSummary blockSummary) {
        HashMap<String, Set<Tree>> result = new HashMap<String, Set<Tree>>();
        UninitializedUsageFindVisitor visitor = new UninitializedUsageFindVisitor(blockSummary.stateOnBlockStart);
        for (Tree element : block.elements()) {
            element.accept(visitor);
        }
        visitor.uninitializedVariableReads.entrySet().stream().filter(e -> !PREDEFINED_VARIABLES.contains(((String)e.getKey()).toUpperCase(Locale.ROOT))).forEach(e -> result.computeIfAbsent((String)e.getKey(), v -> new HashSet()).add((Tree)e.getValue()));
        return result;
    }

    private static Set<String> getLexicalVariableNames(FunctionExpressionTree tree) {
        HashSet<String> result = new HashSet<String>();
        if (tree.lexicalVars() != null) {
            tree.lexicalVars().variables().stream().map(VariableTree::variableExpression).filter(v -> v.is(Tree.Kind.VARIABLE_IDENTIFIER)).forEach(v -> result.add(((VariableIdentifierTree)v).variableExpression().text()));
        }
        return result;
    }

    private static Set<String> getParameterVariableNames(FunctionTree tree) {
        return tree.parameters().parameters().stream().map(p -> p.variableIdentifier().variableExpression().text()).collect(Collectors.toSet());
    }

    private static Set<String> getForEachVariables(ForEachStatementTree tree) {
        HashSet<String> result = new HashSet<String>();
        if (tree.value().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            result.add(((VariableIdentifierTree)tree.value()).variableExpression().text());
        } else {
            TreeUtils.descendants(tree.value(), VariableIdentifierTree.class).forEach(v -> result.add(v.variableExpression().text()));
        }
        if (tree.key() != null) {
            if (tree.key().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                result.add(((VariableIdentifierTree)tree.key()).variableExpression().text());
            } else {
                TreeUtils.descendants(tree.key(), VariableIdentifierTree.class).forEach(v -> result.add(v.variableExpression().text()));
            }
        }
        return result;
    }

    private static BlockSummary getBlockSummary(CfgBlock block) {
        SummaryCreationVisitor visitor = new SummaryCreationVisitor();
        for (Tree element : block.elements()) {
            element.accept(visitor);
        }
        BlockSummary summary = new BlockSummary(visitor.initializedVariables, visitor.scopeWasChanged);
        if (block instanceof CfgBranchingBlock) {
            CfgBranchingBlock branchingBlock = (CfgBranchingBlock)block;
            Tree branchingTree = branchingBlock.branchingTree();
            if (branchingTree.is(Tree.Kind.FOREACH_STATEMENT, Tree.Kind.ALTERNATIVE_FOREACH_STATEMENT)) {
                summary.initializedVariables.addAll(UseOfUninitializedVariableCheck.getForEachVariables((ForEachStatementTree)branchingTree));
            }
        }
        return summary;
    }

    private static boolean isReadAccess(Tree tree) {
        Predicate<Tree> predicate = IS_READ_ACCESS_BY_PARENT_KIND.get(tree.getParent().getKind());
        return predicate == null || predicate.test(tree);
    }

    private static Map<Tree.Kind, Predicate<Tree>> initializeReadPredicate() {
        EnumMap<Tree.Kind, Predicate<Tree>> map = new EnumMap<Tree.Kind, Predicate<Tree>>(Tree.Kind.class);
        PARENT_INITIALIZATION_KIND.forEach(kind -> map.put((Tree.Kind)kind, tree -> false));
        map.put(Tree.Kind.ASSIGNMENT, tree -> tree == ((AssignmentExpressionTree)tree.getParent()).value());
        map.put(Tree.Kind.CALL_ARGUMENT, tree -> {
            if (!tree.getParent().getParent().is(Tree.Kind.FUNCTION_CALL)) {
                return false;
            }
            FunctionCallTree functionCall = (FunctionCallTree)tree.getParent().getParent();
            return tree == functionCall.callee() || FUNCTION_ALLOWING_ARGUMENT_CHECK.contains(CheckUtils.getLowerCaseFunctionName(functionCall));
        });
        map.put(Tree.Kind.ARRAY_ACCESS, tree -> !UseOfUninitializedVariableCheck.isArrayAssignment(tree));
        map.put(Tree.Kind.PARENTHESISED_EXPRESSION, tree -> UseOfUninitializedVariableCheck.isReadAccess(tree.getParent()));
        return map;
    }

    private static boolean isArrayAssignment(Tree tree) {
        Tree child = UseOfUninitializedVariableCheck.skipParentArrayAccess(tree);
        return child.getParent().is(Tree.Kind.ASSIGNMENT) && ((AssignmentExpressionTree)child.getParent()).variable() == child;
    }

    private static Tree skipParentArrayAccess(Tree tree) {
        Tree child;
        for (child = tree; child.getParent().is(Tree.Kind.ARRAY_ACCESS) && ((ArrayAccessTree)child.getParent()).object() == child; child = child.getParent()) {
        }
        return child;
    }

    private static boolean uninitializedVariableDeclaration(VariableIdentifierTree tree) {
        return tree.getParent().is(Tree.Kind.VARIABLE_DECLARATION) && ((VariableDeclarationTree)tree.getParent()).equalToken() == null;
    }

    static {
        FUNCTION_ALLOWING_ARGUMENT_CHECK.add("echo");
        FUNCTION_ALLOWING_ARGUMENT_CHECK.remove("isset");
        IS_READ_ACCESS_BY_PARENT_KIND = UseOfUninitializedVariableCheck.initializeReadPredicate();
    }

    private static class InitialDataCollector
    extends PHPVisitorCheck {
        private final Set<String> exceptionVariables = new HashSet<String>();
        private final Set<String> uninitializedStaticVariables = new HashSet<String>();

        private InitialDataCollector() {
        }

        @Override
        public void visitCatchBlock(CatchBlockTree tree) {
            if (tree.variable() != null) {
                this.exceptionVariables.add(tree.variable().variableExpression().text());
            }
            super.visitCatchBlock(tree);
        }

        @Override
        public void visitVariableIdentifier(VariableIdentifierTree tree) {
            if (UseOfUninitializedVariableCheck.uninitializedVariableDeclaration(tree) && TreeUtils.findAncestorWithKind((Tree)tree, Tree.Kind.STATIC_STATEMENT) != null) {
                this.uninitializedStaticVariables.add(tree.variableExpression().text());
            }
            super.visitVariableIdentifier(tree);
        }
    }

    private static class BlockSummary {
        protected final StateOnBlockStart stateOnBlockStart = new StateOnBlockStart();
        protected Set<String> initializedVariables;
        protected boolean scopeWasChangedLocally;

        public BlockSummary(Set<String> initializedVariables, boolean scopeWasChangedLocally) {
            this.initializedVariables = new HashSet<String>(initializedVariables);
            this.scopeWasChangedLocally = scopeWasChangedLocally;
        }

        protected Set<String> allVariables() {
            HashSet<String> result = new HashSet<String>(this.initializedVariables);
            result.addAll(this.stateOnBlockStart.initializedVariables);
            return result;
        }

        private boolean scopeWasChanged() {
            return this.scopeWasChangedLocally || this.stateOnBlockStart.scopeWasChanged;
        }
    }

    private static class StateOnBlockStart {
        protected final Set<String> initializedVariables = new HashSet<String>();
        protected boolean scopeWasChanged = false;

        private StateOnBlockStart() {
        }

        protected boolean wasInitialized(String variable) {
            return this.initializedVariables.contains(variable);
        }

        private boolean containsBlockSummary(BlockSummary blockSummary) {
            return this.initializedVariables.containsAll(blockSummary.allVariables()) && this.scopeWasChanged == blockSummary.scopeWasChanged();
        }

        private void addBlockSummary(BlockSummary blockSummary) {
            this.initializedVariables.addAll(blockSummary.allVariables());
            this.scopeWasChanged = this.scopeWasChanged || blockSummary.scopeWasChanged();
        }
    }

    private static class UninitializedUsageFindVisitor
    extends ScopeVisitor {
        private final StateOnBlockStart stateOnBlockStart;
        private final Map<String, Tree> uninitializedVariableReads = new HashMap<String, Tree>();

        private UninitializedUsageFindVisitor(StateOnBlockStart stateOnBlockStart) {
            this.stateOnBlockStart = stateOnBlockStart;
        }

        @Override
        public void visitVariableIdentifier(VariableIdentifierTree tree) {
            if (UninitializedUsageFindVisitor.isClassMemberAccess(tree) || UseOfUninitializedVariableCheck.uninitializedVariableDeclaration(tree)) {
                return;
            }
            String name = tree.variableExpression().text();
            if (!UseOfUninitializedVariableCheck.isReadAccess(tree)) {
                this.initializedVariables.add(name);
            } else if (!this.isInitializedRead(name)) {
                this.uninitializedVariableReads.putIfAbsent(name, tree);
            }
            super.visitVariableIdentifier(tree);
        }

        private boolean isInitializedRead(String variable) {
            if (this.scopeWasChanged || this.stateOnBlockStart.scopeWasChanged) {
                return true;
            }
            return this.initializedVariables.contains(variable) || this.stateOnBlockStart.initializedVariables.contains(variable);
        }
    }

    private static class SummaryCreationVisitor
    extends ScopeVisitor {
        private SummaryCreationVisitor() {
        }

        @Override
        public void visitVariableIdentifier(VariableIdentifierTree tree) {
            if (SummaryCreationVisitor.isClassMemberAccess(tree) || UseOfUninitializedVariableCheck.uninitializedVariableDeclaration(tree)) {
                return;
            }
            if (!UseOfUninitializedVariableCheck.isReadAccess(tree)) {
                this.initializedVariables.add(tree.variableExpression().text());
            }
            super.visitVariableIdentifier(tree);
        }
    }

    private static abstract class ScopeVisitor
    extends PHPVisitorCheck {
        protected final Set<String> initializedVariables = new HashSet<String>();
        protected boolean scopeWasChanged = false;

        private ScopeVisitor() {
        }

        @Override
        public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
            if (tree.lexicalVars() != null) {
                tree.lexicalVars().accept(this);
            }
        }

        @Override
        public void visitFunctionCall(FunctionCallTree functionCall) {
            String lowerCaseFunctionName = CheckUtils.getLowerCaseFunctionName(functionCall);
            if (lowerCaseFunctionName != null && FUNCTION_CHANGING_CURRENT_SCOPE.contains(lowerCaseFunctionName)) {
                this.scopeWasChanged = true;
            }
            super.visitFunctionCall(functionCall);
        }

        protected static boolean isClassMemberAccess(Tree tree) {
            Tree child = UseOfUninitializedVariableCheck.skipParentArrayAccess(tree);
            return child.getParent().is(Tree.Kind.CLASS_MEMBER_ACCESS) && ((MemberAccessTree)child.getParent()).member() == child;
        }
    }
}

