/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.tree.impl.declaration.ClassDeclarationTreeImpl;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;

@Rule(key="S2187")
public class NoTestInTestClassCheck
extends PhpUnitCheck {
    private static final String MESSAGE = "Add some tests to this class.";

    @Override
    protected void visitPhpUnitTestCase(ClassDeclarationTree tree) {
        if (!tree.isAbstract() && !this.hasSuperClassWithTestMethod(tree)) {
            this.newIssue(tree.name(), MESSAGE);
        }
        super.visitPhpUnitTestCase(tree);
    }

    private boolean hasSuperClassWithTestMethod(ClassDeclarationTree tree) {
        ClassSymbol symbol = ((ClassDeclarationTreeImpl)tree).symbol();
        return symbol.allSuperTypes().stream().anyMatch(x$0 -> this.hasTestMethod((ClassSymbol)x$0));
    }
}

