/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.type.StaticFunctionCall;
import org.sonar.php.tree.impl.expression.MemberAccessTreeImpl;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S4787")
public class DataEncryptionCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Make sure that encrypting data is safe here.";
    private static final Set<String> SUSPICIOUS_GLOBAL_FUNCTIONS = CheckUtils.lowerCaseSet("mcrypt_ecb", "mcrypt_cfb", "mcrypt_cbc", "mcrypt_encrypt", "openssl_encrypt", "openssl_public_encrypt", "openssl_pkcs7_encrypt", "openssl_seal", "sodium_crypto_aead_aes256gcm_encrypt", "sodium_crypto_aead_chacha20poly1305_encrypt", "sodium_crypto_aead_chacha20poly1305_ietf_encrypt", "sodium_crypto_aead_xchacha20poly1305_ietf_encrypt", "sodium_crypto_box_seal", "sodium_crypto_box", "sodium_crypto_secretbox", "sodium_crypto_stream_xor", "encrypt");
    private static final Set<String> ENCRYPTION_MEMBER = CheckUtils.lowerCaseSet("encryption");
    private static final Set<String> SUSPICIOUS_ENCRYPTION_FUNCTIONS = CheckUtils.lowerCaseSet("create_key", "initialize", "encrypt");
    private static final Set<String> SUSPICIOUS_MEMBER_FUNCTIONS = CheckUtils.lowerCaseSet("encryptByKey", "encryptByPassword");
    private static final List<StaticFunctionCall> SUSPICIOUS_STATIC_FUNCTIONS = Arrays.asList(StaticFunctionCall.staticFunctionCall("Cake\\Utility\\Security::encrypt"), StaticFunctionCall.staticFunctionCall("Cake\\Utility\\Security::engine"), StaticFunctionCall.staticFunctionCall("Illuminate\\Support\\Facades\\Crypt::encrypt"), StaticFunctionCall.staticFunctionCall("Illuminate\\Support\\Facades\\Crypt::encryptString"), StaticFunctionCall.staticFunctionCall("Defuse\\Crypto\\Crypto::encrypt"), StaticFunctionCall.staticFunctionCall("Defuse\\Crypto\\Crypto::encryptWithPassword"), StaticFunctionCall.staticFunctionCall("Defuse\\Crypto\\File::encryptFile"), StaticFunctionCall.staticFunctionCall("Defuse\\Crypto\\File::encryptFileWithPassword"), StaticFunctionCall.staticFunctionCall("Defuse\\Crypto\\File::encryptResource"), StaticFunctionCall.staticFunctionCall("Defuse\\Crypto\\File::encryptResourceWithPassword"), StaticFunctionCall.staticFunctionCall("ParagonIE_Sodium_Compat::crypto_aead_chacha20poly1305_ietf_encrypt"), StaticFunctionCall.staticFunctionCall("ParagonIE_Sodium_Compat::crypto_aead_xchacha20poly1305_ietf_encrypt"), StaticFunctionCall.staticFunctionCall("ParagonIE_Sodium_Compat::crypto_aead_chacha20poly1305_encrypt"), StaticFunctionCall.staticFunctionCall("ParagonIE_Sodium_Compat::crypto_aead_aes256gcm_encrypt"), StaticFunctionCall.staticFunctionCall("ParagonIE_Sodium_Compat::crypto_box"), StaticFunctionCall.staticFunctionCall("ParagonIE_Sodium_Compat::crypto_secretbox"), StaticFunctionCall.staticFunctionCall("ParagonIE_Sodium_Compat::crypto_box_seal"), StaticFunctionCall.staticFunctionCall("ParagonIE_Sodium_Compat::crypto_secretbox_xchacha20poly1305"), StaticFunctionCall.staticFunctionCall("Zend\\Crypt\\PublicKey\\Rsa::factory"), StaticFunctionCall.staticFunctionCall("Zend\\Crypt\\BlockCipher::factory"));
    private static final List<QualifiedName> SUSPICIOUS_CLASS_INSTANTIATIONS = Arrays.asList(QualifiedName.qualifiedName("Joomla\\Crypt\\Cipher_Sodium"), QualifiedName.qualifiedName("Joomla\\Crypt\\Cipher_Simple"), QualifiedName.qualifiedName("Joomla\\Crypt\\Cipher_Rijndael256"), QualifiedName.qualifiedName("Joomla\\Crypt\\Cipher_Crypto"), QualifiedName.qualifiedName("Joomla\\Crypt\\Cipher_Blowfish"), QualifiedName.qualifiedName("Joomla\\Crypt\\Cipher_3DES"), QualifiedName.qualifiedName("phpseclib\\Crypt\\RSA"), QualifiedName.qualifiedName("phpseclib\\Crypt\\AES"), QualifiedName.qualifiedName("phpseclib\\Crypt\\Rijndael"), QualifiedName.qualifiedName("phpseclib\\Crypt\\Twofish"), QualifiedName.qualifiedName("phpseclib\\Crypt\\Blowfish"), QualifiedName.qualifiedName("phpseclib\\Crypt\\RC4"), QualifiedName.qualifiedName("phpseclib\\Crypt\\RC2"), QualifiedName.qualifiedName("phpseclib\\Crypt\\TripleDES"), QualifiedName.qualifiedName("phpseclib\\Crypt\\DES"), QualifiedName.qualifiedName("Zend\\Crypt\\PublicKey\\DiffieHellman"), QualifiedName.qualifiedName("Zend\\Crypt\\PublicKey\\Rsa"), QualifiedName.qualifiedName("Zend\\Crypt\\FileCipher"), QualifiedName.qualifiedName("Zend\\Crypt\\Hybrid"), QualifiedName.qualifiedName("Zend\\Crypt\\BlockCipher"));
    private static final QualifiedName JOOMLA_CIPHER_INTERFACE = QualifiedName.qualifiedName("Joomla\\Crypt\\CipherInterface");
    private static final QualifiedName CODE_IGNITER_CONTROLLER_CLASS = QualifiedName.qualifiedName("CI_Controller");

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        this.checkSuspiciousClassDeclaration(tree);
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.checkSuspiciousClassDeclaration(tree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        ExpressionTree callee = tree.callee();
        if (DataEncryptionCheck.isSuspiciousGlobalFunction(callee) || this.isSuspiciousMemberFunction(callee) || this.isSuspiciousClassInstantiation(callee)) {
            this.context().newIssue(this, tree, MESSAGE);
        }
        super.visitFunctionCall(tree);
    }

    @Override
    public void visitNewExpression(NewExpressionTree tree) {
        if (this.isSuspiciousClassInstantiation(tree.expression())) {
            this.context().newIssue(this, tree, MESSAGE);
        }
        super.visitNewExpression(tree);
    }

    private void checkSuspiciousClassDeclaration(ClassTree tree) {
        QualifiedName fullyQualifiedSuperclassName;
        NamespaceNameTree superClass = tree.superClass();
        if (superClass != null && (fullyQualifiedSuperclassName = this.getFullyQualifiedName(superClass)).equals(CODE_IGNITER_CONTROLLER_CLASS)) {
            this.checkCodeIgniterControllerMethods(tree);
        }
        tree.superInterfaces().stream().filter(superInterface -> JOOMLA_CIPHER_INTERFACE.equals(this.getFullyQualifiedName((NamespaceNameTree)superInterface))).forEach(superInterface -> this.context().newIssue(this, (Tree)superInterface, MESSAGE));
    }

    private void checkCodeIgniterControllerMethods(ClassTree classTree) {
        for (ClassMemberTree member : classTree.members()) {
            if (!member.is(Tree.Kind.METHOD_DECLARATION)) continue;
            MethodDeclarationTree method = (MethodDeclarationTree)member;
            CodeIgniterMethodCallChecker codeIgniterMethodCallChecker = new CodeIgniterMethodCallChecker();
            method.body().accept(codeIgniterMethodCallChecker);
            codeIgniterMethodCallChecker.suspiciousFunctionCalls.forEach(tree -> this.context().newIssue(this, (Tree)tree, MESSAGE));
        }
    }

    private boolean isSuspiciousMemberFunction(ExpressionTree callee) {
        if (callee.is(Tree.Kind.CLASS_MEMBER_ACCESS, Tree.Kind.OBJECT_MEMBER_ACCESS)) {
            MemberAccessTreeImpl memberAccess = (MemberAccessTreeImpl)callee;
            if (DataEncryptionCheck.isStaticFunction(memberAccess)) {
                QualifiedName className = this.getFullyQualifiedName((NamespaceNameTree)memberAccess.object());
                String memberName = ((NameIdentifierTree)memberAccess.member()).text();
                return SUSPICIOUS_STATIC_FUNCTIONS.stream().anyMatch(staticFunctionCall -> staticFunctionCall.matches(className, memberName));
            }
            if (memberAccess.member().is(Tree.Kind.NAME_IDENTIFIER)) {
                return SUSPICIOUS_MEMBER_FUNCTIONS.contains(((NameIdentifierTree)memberAccess.member()).text().toLowerCase(Locale.ROOT));
            }
        }
        return false;
    }

    private boolean isSuspiciousClassInstantiation(ExpressionTree callee) {
        if (callee.is(Tree.Kind.NAMESPACE_NAME)) {
            NamespaceNameTree classNameTree = (NamespaceNameTree)callee;
            QualifiedName className = this.getFullyQualifiedName(classNameTree);
            return SUSPICIOUS_CLASS_INSTANTIATIONS.stream().anyMatch(className::equals);
        }
        return false;
    }

    private static boolean isSuspiciousGlobalFunction(ExpressionTree callee) {
        return callee.is(Tree.Kind.NAMESPACE_NAME) && SUSPICIOUS_GLOBAL_FUNCTIONS.contains(((NamespaceNameTree)callee).qualifiedName().toLowerCase(Locale.ROOT));
    }

    private static boolean isStaticFunction(MemberAccessTreeImpl memberAccess) {
        return memberAccess.isStatic() && memberAccess.object().is(Tree.Kind.NAMESPACE_NAME) && memberAccess.member().is(Tree.Kind.NAME_IDENTIFIER);
    }

    private static class CodeIgniterMethodCallChecker
    extends PHPVisitorCheck {
        private List<Tree> suspiciousFunctionCalls = new ArrayList<Tree>();

        private CodeIgniterMethodCallChecker() {
        }

        @Override
        public void visitFunctionCall(FunctionCallTree tree) {
            ExpressionTree callee = tree.callee();
            if (CodeIgniterMethodCallChecker.isSuspiciousEncryptionFunction(callee)) {
                this.suspiciousFunctionCalls.add(tree);
            }
            super.visitFunctionCall(tree);
        }

        private static boolean isSuspiciousEncryptionFunction(Tree tree) {
            return CodeIgniterMethodCallChecker.isMemberAccess(tree, SUSPICIOUS_ENCRYPTION_FUNCTIONS) && CodeIgniterMethodCallChecker.isMemberAccess(((MemberAccessTree)tree).object(), ENCRYPTION_MEMBER);
        }

        private static boolean isMemberAccess(Tree tree, Set<String> expectedNames) {
            if (tree.is(Tree.Kind.OBJECT_MEMBER_ACCESS)) {
                Tree member = ((MemberAccessTree)tree).member();
                if (member.is(Tree.Kind.NAME_IDENTIFIER)) {
                    return expectedNames.contains(((NameIdentifierTree)member).text().toLowerCase(Locale.ROOT));
                }
            }
            return false;
        }
    }
}

