/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.type.NewObjectCall;
import org.sonar.php.checks.utils.type.ObjectMemberFunctionCall;
import org.sonar.php.checks.utils.type.TreeValues;
import org.sonar.php.checks.utils.type.TypePredicateList;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringLiteralTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2077")
public class QueryUsageCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Make sure that formatting this SQL query is safe here.";
    private static final NewObjectCall IS_PDO_OBJECT = new NewObjectCall("PDO");
    private static final NewObjectCall IS_MYSQLI_OBJECT = new NewObjectCall("mysqli");
    private static final Tree.Kind[] LITERALS = new Tree.Kind[]{Tree.Kind.REGULAR_STRING_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.NUMERIC_LITERAL};
    private static final String STATEMENT = "statement";
    private static final String QUERY = "query";
    private static final Map<String, Integer> SUSPICIOUS_GLOBAL_FUNCTIONS = QueryUsageCheck.buildSuspiciousGlobalFunctions();
    private static final Predicate<TreeValues> SUSPICIOUS_PDO_QUERY_PREDICATES = new TypePredicateList(new ObjectMemberFunctionCall("exec", IS_PDO_OBJECT), new ObjectMemberFunctionCall("query", IS_PDO_OBJECT));
    private static final Predicate<TreeValues> SUSPICIOUS_MYSQLI_QUERY_PREDICATES = new TypePredicateList(new ObjectMemberFunctionCall("query", IS_MYSQLI_OBJECT), new ObjectMemberFunctionCall("real_query", IS_MYSQLI_OBJECT), new ObjectMemberFunctionCall("multi_query", IS_MYSQLI_OBJECT), new ObjectMemberFunctionCall("send_query", IS_MYSQLI_OBJECT));
    private static final Predicate<TreeValues> PDO_PREPARE_PREDICATE = new ObjectMemberFunctionCall("prepare", new NewObjectCall("PDO"));

    private static Map<String, Integer> buildSuspiciousGlobalFunctions() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("mssql_query", 0);
        map.put("mysql_query", 0);
        map.put("mysql_db_query", 1);
        map.put("mysql_unbuffered_query", 0);
        map.put("pg_send_query", 1);
        map.put("mysqli_query", 1);
        map.put("mysqli_real_query", 1);
        map.put("mysqli_multi_query", 1);
        map.put("mysqli_send_query", 1);
        return map;
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        TreeValues possibleValues = TreeValues.of(tree, this.context().symbolTable());
        if (this.isSuspiciousGlobalFunction(tree) || this.isSuspiciousMemberFunction(tree, possibleValues) || this.isSuspiciousPrepareStatement(tree, possibleValues)) {
            this.context().newIssue(this, tree.callee(), MESSAGE);
        }
        super.visitFunctionCall(tree);
    }

    private boolean isSuspiciousGlobalFunction(FunctionCallTree tree) {
        ExpressionTree callee = tree.callee();
        if (callee.is(Tree.Kind.NAMESPACE_NAME)) {
            String qualifiedNameLowerCase = ((NamespaceNameTree)callee).qualifiedName().toLowerCase(Locale.ENGLISH);
            if (SUSPICIOUS_GLOBAL_FUNCTIONS.containsKey(qualifiedNameLowerCase)) {
                Integer index = SUSPICIOUS_GLOBAL_FUNCTIONS.get(qualifiedNameLowerCase);
                Optional<CallArgumentTree> argument = CheckUtils.argument(tree, QUERY, index);
                return argument.isPresent() && this.isSuspiciousArgument(argument.get().value());
            }
            if ("pg_query".equals(qualifiedNameLowerCase)) {
                SeparatedList<CallArgumentTree> callArguments = tree.callArguments();
                Optional<Object> argument = Optional.empty();
                if (callArguments.size() == 1) {
                    argument = CheckUtils.argument(tree, QUERY, 0);
                }
                if (callArguments.size() == 2) {
                    argument = CheckUtils.argument(tree, QUERY, 1);
                }
                return argument.isPresent() && this.isSuspiciousArgument(((CallArgumentTree)argument.get()).value());
            }
        }
        return false;
    }

    private boolean isSuspiciousMemberFunction(FunctionCallTree tree, TreeValues possibleValues) {
        if (SUSPICIOUS_MYSQLI_QUERY_PREDICATES.test(possibleValues)) {
            Optional<CallArgumentTree> argument = CheckUtils.argument(tree, QUERY, 0);
            return argument.isPresent() && this.isSuspiciousArgument(argument.get().value());
        }
        if (SUSPICIOUS_PDO_QUERY_PREDICATES.test(possibleValues)) {
            Optional<CallArgumentTree> argument = CheckUtils.argument(tree, STATEMENT, 0);
            return argument.isPresent() && this.isSuspiciousArgument(argument.get().value());
        }
        return false;
    }

    private boolean isSuspiciousPrepareStatement(FunctionCallTree tree, TreeValues possibleValues) {
        Optional<CallArgumentTree> argument = CheckUtils.argument(tree, STATEMENT, 0);
        return PDO_PREPARE_PREDICATE.test(possibleValues) && argument.isPresent() && this.isSuspiciousArgument(argument.get().value());
    }

    private boolean isSuspiciousArgument(ExpressionTree expression) {
        return expression.is(Tree.Kind.EXPANDABLE_STRING_LITERAL) && this.isSuspiciousExpandableString((ExpandableStringLiteralTree)expression) || expression.is(Tree.Kind.CONCATENATION) && this.isSuspiciousConcat((BinaryExpressionTree)expression);
    }

    private boolean isSuspiciousExpandableString(ExpandableStringLiteralTree tree) {
        for (ExpressionTree element : tree.expressions()) {
            if (element.is(Tree.Kind.VARIABLE_IDENTIFIER) && !this.isSuspiciousVariable((VariableIdentifierTree)element)) continue;
            return true;
        }
        return false;
    }

    private boolean isSuspiciousConcat(BinaryExpressionTree tree) {
        boolean isSuspicious = false;
        ArrayDeque<ExpressionTree> operands = new ArrayDeque<ExpressionTree>();
        operands.add(tree.leftOperand());
        operands.add(tree.rightOperand());
        block5: while (!isSuspicious && !operands.isEmpty()) {
            ExpressionTree operand = (ExpressionTree)operands.pop();
            switch (operand.getKind()) {
                case BOOLEAN_LITERAL: 
                case NULL_LITERAL: 
                case REGULAR_STRING_LITERAL: 
                case NUMERIC_LITERAL: {
                    continue block5;
                }
                case CONCATENATION: {
                    operands.add(((BinaryExpressionTree)operand).leftOperand());
                    operands.add(((BinaryExpressionTree)operand).rightOperand());
                    continue block5;
                }
                case VARIABLE_IDENTIFIER: {
                    isSuspicious = this.isSuspiciousVariable((VariableIdentifierTree)operand);
                    continue block5;
                }
            }
            isSuspicious = true;
        }
        return isSuspicious;
    }

    private boolean isSuspiciousVariable(VariableIdentifierTree variable) {
        return !CheckUtils.assignedValue(variable).is(LITERALS);
    }
}

