/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.symbols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.php.symbols.BuiltinSymbolData;
import org.sonar.php.symbols.ClassSymbolData;
import org.sonar.php.symbols.FunctionSymbolData;
import org.sonar.plugins.php.api.symbols.QualifiedName;

public class ProjectSymbolData {
    private static final BuiltinSymbolData builtinSymbolData = BuiltinSymbolData.BUILTINS;
    private final Map<QualifiedName, ClassSymbolData> classSymbolsByQualifiedName = new HashMap<QualifiedName, ClassSymbolData>();
    private final Map<QualifiedName, List<FunctionSymbolData>> functionSymbolsByQualifiedName = new HashMap<QualifiedName, List<FunctionSymbolData>>();

    public void add(ClassSymbolData classSymbolData) {
        this.classSymbolsByQualifiedName.put(classSymbolData.qualifiedName(), classSymbolData);
    }

    public void add(FunctionSymbolData functionSymbolData) {
        this.functionSymbolsByQualifiedName.computeIfAbsent(functionSymbolData.qualifiedName(), k -> new ArrayList(1)).add(functionSymbolData);
    }

    public Optional<ClassSymbolData> classSymbolData(QualifiedName qualifiedName) {
        ClassSymbolData value = this.classSymbolsByQualifiedName.get(qualifiedName);
        return value == null ? builtinSymbolData.classSymbolData(qualifiedName) : Optional.of(value);
    }

    public List<FunctionSymbolData> functionSymbolData(QualifiedName qualifiedName) {
        return this.functionSymbolsByQualifiedName.getOrDefault(qualifiedName, Collections.emptyList());
    }

    public Map<QualifiedName, ClassSymbolData> classSymbolsByQualifiedName() {
        return this.classSymbolsByQualifiedName;
    }

    public Map<QualifiedName, List<FunctionSymbolData>> functionSymbolsByQualifiedName() {
        return this.functionSymbolsByQualifiedName;
    }
}

