/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.SeparatedListImpl;
import org.sonar.php.tree.symbols.HasClassSymbol;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.AttributeGroupTree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class AnonymousClassTreeImpl
extends PHPTree
implements AnonymousClassTree,
HasClassSymbol {
    private static final Tree.Kind KIND = Tree.Kind.ANONYMOUS_CLASS;
    private final List<AttributeGroupTree> attributeGroups;
    private final SyntaxToken classToken;
    private final SyntaxToken openParenthesisToken;
    private final SeparatedList<ExpressionTree> arguments;
    private final SyntaxToken closeParenthesisToken;
    private final SyntaxToken extendsToken;
    private final NamespaceNameTree superClass;
    private final SyntaxToken implementsToken;
    private final SeparatedListImpl<NamespaceNameTree> superInterfaces;
    private final SyntaxToken openCurlyBraceToken;
    private final List<ClassMemberTree> members;
    private final SyntaxToken closeCurlyBraceToken;
    private final SeparatedList<CallArgumentTree> callArguments;
    @Nullable
    private final SyntaxToken readonly;
    private ClassSymbol symbol;

    public AnonymousClassTreeImpl(List<AttributeGroupTree> attributeGroups, @Nullable SyntaxToken readonly, SyntaxToken classToken, @Nullable SyntaxToken openParenthesisToken, SeparatedList<CallArgumentTree> callArguments, @Nullable SyntaxToken closeParenthesisToken, @Nullable SyntaxToken extendsToken, @Nullable NamespaceNameTree superClass, @Nullable SyntaxToken implementsToken, @Nullable SeparatedListImpl<NamespaceNameTree> superInterfaces, SyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, SyntaxToken closeCurlyBraceToken) {
        List<ExpressionTree> argumentValues = callArguments.stream().map(CallArgumentTree::value).toList();
        this.attributeGroups = attributeGroups;
        this.readonly = readonly;
        this.classToken = classToken;
        this.openParenthesisToken = openParenthesisToken;
        this.callArguments = callArguments;
        this.arguments = new SeparatedListImpl<ExpressionTree>(argumentValues, callArguments.getSeparators());
        this.closeParenthesisToken = closeParenthesisToken;
        this.extendsToken = extendsToken;
        this.superClass = superClass;
        this.implementsToken = implementsToken;
        this.superInterfaces = superInterfaces;
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.members = members;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
    }

    @Override
    public List<AttributeGroupTree> attributeGroups() {
        return this.attributeGroups;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly != null;
    }

    @Override
    public SyntaxToken classToken() {
        return this.classToken;
    }

    @Override
    @Nullable
    public SyntaxToken openParenthesisToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    @Deprecated
    public SeparatedList<ExpressionTree> arguments() {
        return this.arguments;
    }

    @Override
    public SeparatedList<CallArgumentTree> callArguments() {
        return this.callArguments;
    }

    @Override
    @Nullable
    public SyntaxToken closeParenthesisToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    @Nullable
    public SyntaxToken extendsToken() {
        return this.extendsToken;
    }

    @Override
    @Nullable
    public NamespaceNameTree superClass() {
        return this.superClass;
    }

    @Override
    @Nullable
    public SyntaxToken implementsToken() {
        return this.implementsToken;
    }

    @Override
    public SeparatedList<NamespaceNameTree> superInterfaces() {
        return this.superInterfaces;
    }

    @Override
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public List<ClassMemberTree> members() {
        return this.members;
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    @Nullable
    public MethodDeclarationTree fetchConstructor() {
        MethodDeclarationTree constructor = null;
        for (ClassMemberTree member : this.members) {
            MethodDeclarationTree method;
            String methodName;
            if (!member.is(Tree.Kind.METHOD_DECLARATION) || !"__construct".equalsIgnoreCase(methodName = (method = (MethodDeclarationTree)member).name().text())) continue;
            constructor = method;
        }
        return constructor;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(this.attributeGroups.iterator(), IteratorUtils.iteratorOf(this.readonly, this.classToken, this.openParenthesisToken), this.callArguments.elementsAndSeparators(), IteratorUtils.iteratorOf(this.closeParenthesisToken, this.extendsToken, this.superClass, this.implementsToken), this.superInterfaces.elementsAndSeparators(), IteratorUtils.iteratorOf(this.openCurlyBraceToken), this.members.iterator(), IteratorUtils.iteratorOf(this.closeCurlyBraceToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitAnonymousClass(this);
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public ClassSymbol symbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(ClassSymbol symbol) {
        this.symbol = symbol;
    }
}

