/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.handler;

import com.teamscale.core.config.ServerConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.service.framework.IServiceServer;
import com.teamscale.service.framework.IStaticServiceContext;
import com.teamscale.service.framework.ServerStartFailedException;
import com.teamscale.service.framework.impl.ApiApplication;
import com.teamscale.service.framework.impl.factory.StaticContextFactory;
import com.teamscale.service.framework.impl.handler.HTTPSUtils;
import com.teamscale.service.framework.impl.handler.InFlightRequestFilter;
import com.teamscale.service.framework.impl.handler.JettyStatisticsCollector;
import com.teamscale.service.framework.impl.handler.StaticServiceContext;
import jakarta.servlet.Filter;
import java.time.Duration;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.rewrite.handler.RedirectPatternRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.CrossOriginHandler;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.Callback;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jspecify.annotations.NonNull;

class ServiceServer
implements IServiceServer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String hostname;
    private final int port;
    private final String urlPrefix;
    private final InFlightRequestFilter inFlightRequestFilter;
    private Server server;
    private final ServerConfiguration serverConfiguration;
    private static boolean statisticsCollectorRegistered = false;

    public ServiceServer(ServerConfiguration configuration) {
        String urlPrefix = configuration.getUrlPrefix();
        urlPrefix = StringUtils.ensureEndsWith((String)urlPrefix, (String)"/");
        this.urlPrefix = urlPrefix = StringUtils.stripPrefix((String)urlPrefix, (String)"/");
        this.port = configuration.getHttpPort();
        this.hostname = configuration.getBindHostname();
        this.serverConfiguration = configuration;
        this.inFlightRequestFilter = new InFlightRequestFilter();
    }

    public void startServer(IndexLayer indexLayer, ILockProvider lockProvider) {
        if (this.server != null) {
            throw new IllegalStateException("Server already running");
        }
        this.server = new Server();
        if (this.port != 0) {
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setRequestHeaderSize(1024 * this.serverConfiguration.getMaxHeaderSizeKiB());
            httpConfiguration.setUriCompliance(UriCompliance.UNSAFE);
            httpConfiguration.setSendServerVersion(false);
            if (this.serverConfiguration.isHttpsConfigured()) {
                httpConfiguration.setSecurePort(this.serverConfiguration.getHttpsPort());
            }
            ServerConnector httpConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
            httpConnector.setPort(this.port);
            if (this.hostname != null) {
                httpConnector.setHost(this.hostname);
            }
            this.server.addConnector((Connector)httpConnector);
        }
        if (this.serverConfiguration.isHttpsConfigured()) {
            HTTPSUtils.enableHTTPS(this.server, this.serverConfiguration);
        }
        try {
            this.server.setHandler(this.createHandler(indexLayer, lockProvider));
            this.server.start();
        }
        catch (Exception e) {
            LOGGER.fatal("Exception occurred in the HTTP server: " + e.getMessage(), (Throwable)e);
            throw new ServerStartFailedException((Throwable)e);
        }
        LOGGER.info("Successfully started " + this.getClass().getSimpleName());
    }

    private Handler createJerseyHandler(IStaticServiceContext staticServiceContext, String prefix) {
        ServletContextHandler context = new ServletContextHandler(prefix);
        context.getServletHandler().setDecodeAmbiguousURIs(true);
        ServletHolder jerseyServlet = context.addServlet(ServletContainer.class, "/*");
        jerseyServlet.setInitParameter("jakarta.ws.rs.Application", ApiApplication.class.getName());
        jerseyServlet.getRegistration().setLoadOnStartup(0);
        StaticContextFactory.attachTo(context, staticServiceContext);
        this.addCrossOriginFilter(context);
        if (FileSystemUtils.isDevModeOrJunitTest()) {
            this.addInFlightRequestFilter(context);
        }
        return context;
    }

    private void addInFlightRequestFilter(ServletContextHandler context) {
        context.addFilter((Filter)this.inFlightRequestFilter, "/*", null);
    }

    private void addCrossOriginFilter(ServletContextHandler context) {
        ServerConfiguration.CorsConfiguration corsConfiguration = this.serverConfiguration.getCorsConfiguration();
        CrossOriginHandler crossOriginHandler = new CrossOriginHandler();
        crossOriginHandler.setAllowedHeaders(corsConfiguration.allowedHeaders());
        crossOriginHandler.setAllowedOriginPatterns(corsConfiguration.allowedOrigins().stream().map(Pattern::pattern).collect(Collectors.toSet()));
        crossOriginHandler.setAllowedMethods(corsConfiguration.allowedMethods());
        crossOriginHandler.setAllowCredentials(corsConfiguration.allowCredentials());
        crossOriginHandler.setDeliverPreflightRequests(false);
        context.insertHandler((Handler.Singleton)crossOriginHandler);
    }

    private Handler createHandler(IndexLayer indexLayer, ILockProvider lockProvider) throws StorageException {
        StaticServiceContext staticServiceContext = new StaticServiceContext(indexLayer, this.serverConfiguration, lockProvider);
        String prefix = "/" + UniformPathUtils.cleanPath((String)this.urlPrefix);
        Handler mainHandler = this.createJerseyHandler(staticServiceContext, prefix);
        mainHandler = this.wrapInRedirectHandler(mainHandler);
        if (this.serverConfiguration.isHttpsConfigured()) {
            mainHandler = ServiceServer.setUpHttpToHttpsRedirect(mainHandler);
            mainHandler = ServiceServer.setUpHstsHeader(mainHandler);
        }
        mainHandler = this.wrapInStatisticsCollector(mainHandler);
        return mainHandler;
    }

    private synchronized Handler wrapInStatisticsCollector(Handler mainHandler) {
        if (statisticsCollectorRegistered) {
            return mainHandler;
        }
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler(mainHandler);
        new JettyStatisticsCollector(stats);
        statisticsCollectorRegistered = true;
        return stats;
    }

    private static Handler setUpHttpToHttpsRedirect(Handler mainHandler) {
        if (Boolean.getBoolean("com.teamscale.ssl.disable-redirect")) {
            return mainHandler;
        }
        return new SecuredRedirectHandler(mainHandler);
    }

    private static Handler setUpHstsHeader(Handler mainHandler) {
        if (Boolean.getBoolean("com.teamscale.ssl.disable-hsts")) {
            return mainHandler;
        }
        RewriteHandler hstsRewriteHandler = new RewriteHandler(mainHandler);
        hstsRewriteHandler.addRule((Rule)new HstsHeaderRule(Duration.ofDays(365L)));
        return hstsRewriteHandler;
    }

    private Handler wrapInRedirectHandler(Handler primaryHandler) {
        RewriteHandler rewriteHandler = new RewriteHandler();
        rewriteHandler.addRule((Rule)new RedirectPatternRule("/", "/" + this.urlPrefix));
        return new Handler.Sequence(new Handler[]{primaryHandler, rewriteHandler});
    }

    public void stopServer() throws Exception {
        if (!this.isRunning()) {
            throw new IllegalStateException("Server not running");
        }
        this.server.stop();
        this.server = null;
    }

    public void waitForActiveRequestsToCompleteAndPreventNew() throws InterruptedException {
        this.inFlightRequestFilter.blockNewRequests();
        this.inFlightRequestFilter.waitForActiveRequestsToComplete();
    }

    public void reAllowNewRequests() {
        this.inFlightRequestFilter.unblockNewRequests();
    }

    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    private static class HstsHeaderRule
    extends Rule {
        private static final String STRICT_TRANSPORT_SECURITY_HEADER_NAME = "Strict-Transport-Security";
        private final String headerValue;

        private HstsHeaderRule(@NonNull Duration maxAge) {
            Objects.requireNonNull(maxAge, "maxAge");
            if (maxAge.isNegative() || maxAge.isZero()) {
                throw new IllegalArgumentException("maxAge (%s) must be positive".formatted(maxAge));
            }
            this.headerValue = "max-age=" + maxAge.toSeconds();
        }

        public Rule.Handler matchAndApply(Rule.Handler input) {
            if (!input.getConnectionMetaData().isSecure()) {
                return null;
            }
            return new Rule.Handler(input){

                protected boolean handle(Response response, Callback callback) throws Exception {
                    response.getHeaders().put(HstsHeaderRule.STRICT_TRANSPORT_SECURITY_HEADER_NAME, headerValue);
                    return super.handle(response, callback);
                }
            };
        }
    }
}

