/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.impl.provider.FunctionalConverter;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.string.StringUtils;

@Provider
public class ColorConverterProvider
implements ParamConverterProvider {
    public <P> ParamConverter<P> getConverter(Class<P> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(Color.class)) {
            return new FunctionalConverter(annotations, ColorConverterProvider::convert);
        }
        return null;
    }

    private static Color convert(String colorString) throws InvalidValueException {
        if (StringUtils.isEmpty((String)colorString)) {
            return null;
        }
        Color color = ColorUtils.fromString((String)colorString);
        if (color == null) {
            throw new InvalidValueException("Color value must either be of the form #AABBCC or a simple color name.");
        }
        return color;
    }
}

