/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass(containedInBackup=true)
public class CompactLines
implements Serializable,
Iterable<Integer> {
    private static final long serialVersionUID = 1L;
    private BitSet bitSet = new BitSet();

    public CompactLines() {
    }

    public CompactLines(Iterable<Integer> lines) {
        for (Integer line : lines) {
            this.bitSet.set(line);
        }
    }

    public CompactLines(int ... lines) {
        int[] nArray = lines;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer line = nArray[i];
            this.bitSet.set(line);
        }
    }

    public int size() {
        return this.bitSet.cardinality();
    }

    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    public void addAll(CompactLines lines) {
        this.bitSet.or(lines.bitSet);
    }

    public boolean contains(int line) {
        return this.bitSet.get(line);
    }

    public boolean containsAny(int start, int end) {
        int nextSetBit = this.bitSet.nextSetBit(start);
        return nextSetBit != -1 && nextSetBit <= end;
    }

    public boolean containsAny(LineBasedRegion region) {
        return this.containsAny(region.getStart(), region.getEnd());
    }

    public boolean containsAll(Iterable<Integer> lines) {
        for (Integer line : lines) {
            if (this.bitSet.get(line)) continue;
            return false;
        }
        return true;
    }

    public void add(int line) {
        this.bitSet.set(line);
    }

    public void addRange(int startLine, int endLine) {
        this.bitSet.set(startLine, endLine + 1);
    }

    public void remove(int line) {
        this.bitSet.clear(line);
    }

    public void removeAll(CompactLines lines) {
        this.bitSet.andNot(lines.bitSet);
    }

    public void clear() {
        this.bitSet.clear();
    }

    public void retainAll(CompactLines lines) {
        this.bitSet.and(lines.bitSet);
    }

    public CompactLines intersection(CompactLines other) {
        CompactLines intersection = new CompactLines(this);
        intersection.retainAll(other);
        return intersection;
    }

    public boolean intersects(CompactLines lines) {
        return this.bitSet.intersects(lines.bitSet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactLines integers = (CompactLines)o;
        return Objects.equals(this.bitSet, integers.bitSet);
    }

    public int hashCode() {
        return Objects.hashCode(this.bitSet);
    }

    public String toString() {
        return StringUtils.concat(this, ",");
    }

    public Optional<Integer> getHighestLineNumber() {
        if (this.bitSet.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.bitSet.previousSetBit(this.bitSet.length() - 1));
    }

    private void readObject(ObjectInputStream inputStream) throws IOException {
        byte[] bytes = FileSystemUtils.readStreamBinary(inputStream);
        this.bitSet = BitSet.valueOf(bytes);
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        byte[] bytes = this.bitSet.toByteArray();
        outputStream.write(bytes);
    }

    @Override
    public @NonNull Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int currentIndex = -1;

            @Override
            public boolean hasNext() {
                int nextIndex = CompactLines.this.bitSet.nextSetBit(this.currentIndex + 1);
                return nextIndex != -1;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.currentIndex = CompactLines.this.bitSet.nextSetBit(this.currentIndex + 1);
                return this.currentIndex;
            }
        };
    }
}

