/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class LimitedWriter
extends Writer {
    private final Writer delegate;
    private int charsRemaining;

    public LimitedWriter(Writer delegate, int maxChars) {
        if (maxChars < 0) {
            throw new IllegalArgumentException("Negative number of maximum characters");
        }
        this.delegate = Objects.requireNonNull(delegate);
        this.charsRemaining = maxChars;
    }

    @Override
    public void write(char[] buffer, int offset, int length) throws IOException {
        if (this.charsRemaining >= length) {
            this.delegate.write(buffer, offset, length);
            this.charsRemaining -= length;
        } else if (this.charsRemaining >= 0) {
            this.delegate.write(buffer, offset, this.charsRemaining);
            this.delegate.write("[...]");
            this.charsRemaining = -1;
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

