/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.util.function.Supplier;
import org.conqat.lib.commons.options.CommandLine;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.options.OptionException;
import org.conqat.lib.commons.options.OptionRegistry;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public abstract class CommandLineBase<E extends Exception> {
    private CommandLine cmdLine;

    @Option(shortName=104, longName="help", description="print this usage message")
    public void printUsageAndExit() {
        this.cmdLine.printUsage(System.err);
        System.exit(1);
    }

    protected void initFromCommandLine(String[] args) {
        this.cmdLine = new CommandLine(new OptionRegistry(this));
        try {
            String[] leftOvers = this.cmdLine.parse(args);
            this.handleLeftOvers(leftOvers);
        }
        catch (OptionException e) {
            CommandLineBase.abort("Incorrect options: " + e.getMessage());
        }
    }

    protected void handleLeftOvers(String[] leftOvers) {
        if (leftOvers.length > 0) {
            CommandLineBase.printError("Unsupported trailing options: " + StringUtils.concat(leftOvers, " "));
            this.printUsageAndExit();
        }
    }

    protected static void abort(String message) {
        CommandLineBase.printError(message);
        System.exit(-1);
    }

    protected abstract void run() throws E;

    protected static <E extends Exception> void execute(Supplier<CommandLineBase<E>> constructor, String[] args) throws E {
        CommandLineBase<E> tool = constructor.get();
        tool.initFromCommandLine(args);
        tool.run();
    }

    protected static void exitIfFalse(boolean condition, String message) {
        CommandLineBase.exitIfTrue(!condition, message);
    }

    protected static void exitIfTrue(boolean condition, String message) {
        if (condition) {
            CommandLineBase.exitWithMessage(message, null);
        }
    }

    protected static void exitWithMessage(String message) {
        CommandLineBase.exitWithMessage(message, null);
    }

    protected static void exitWithMessage(String message, @Nullable Exception e) {
        CommandLineBase.printError(message, e);
        System.exit(1);
    }

    protected static void printInfo(String message) {
        System.out.println(message);
    }

    protected static void printError(String message) {
        System.err.println(message);
    }

    protected static void printError(String message, Exception exception) {
        CommandLineBase.printError(message);
        if (exception != null) {
            exception.printStackTrace();
        }
    }
}

