/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core;

import java.util.EnumSet;
import java.util.Set;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public enum EStartableComponent {
    WORKER,
    SERVICE_SERVER;

    private static final String PROPERTY_NAME = "com.teamscale.started-components";
    private static final Set<EStartableComponent> STARTED_COMPONENTS;

    private static Set<EStartableComponent> fromSystemProperty() {
        String components = System.getProperty(PROPERTY_NAME);
        if (StringUtils.isEmpty((String)components)) {
            return EnumSet.allOf(EStartableComponent.class);
        }
        EnumSet<EStartableComponent> componentsToStart = EnumSet.noneOf(EStartableComponent.class);
        for (String part : components.split(",")) {
            EStartableComponent value = (EStartableComponent)EnumUtils.valueOfIgnoreCase(EStartableComponent.class, (String)part.trim());
            if (value == null) {
                throw new RuntimeException("Unknown startable component: " + part);
            }
            componentsToStart.add(value);
        }
        return componentsToStart;
    }

    public boolean isEnabled() {
        return STARTED_COMPONENTS.contains((Object)this);
    }

    public static boolean isCloudMode() {
        return !SERVICE_SERVER.isEnabled() || !WORKER.isEnabled();
    }

    static {
        STARTED_COMPONENTS = EStartableComponent.fromSystemProperty();
    }
}

