/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.i9d;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.ai.AiEngineProviderOptionBase;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.i9d.I9DAiClient;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="ai-engine.i9d", name="I9D Provider", visibilityFeatureToggle=EFeatureToggle.APPLE_AI_SUPPORT, type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AI, orderingHint=3000)
@IndexValueClass(containedInBackup=true)
public class I9DAiEngineProviderOption
extends AiEngineProviderOptionBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="baseUrl")
    @OptionFieldDescription(name="The URL of the service")
    public String baseUrl;
    @JsonProperty(value="model")
    @OptionFieldDescription(name="The name of the model to use")
    public String model;
    @JsonProperty(value="accessToken")
    @PasswordOption
    @OptionFieldDescription(name="Access token")
    public String accessToken;

    @Override
    public String getInternalName() {
        return "i9d." + this.model;
    }

    @Override
    public String getDisplayName() {
        return "Apple AI (" + this.model + ")";
    }

    @Override
    public Optional<ILlmCompleter> createCompleter(@Nullable BiConsumer<String, Long> usageReporter) {
        return Optional.of(new I9DAiClient(this.baseUrl, this.model, this.accessToken, this.temperature));
    }
}

