/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.ollama;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.ai.ollama.IOllamaApi;
import com.teamscale.core.ai.ollama.model.OllamaChatMessageDTO;
import com.teamscale.core.rest.client.Retrofit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OllamaClient
implements ILlmCompleter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String model;
    private final IOllamaApi service;
    private final double temperature;

    public OllamaClient(String baseUrl, String model, double temperature) {
        this.model = model;
        this.service = OllamaClient.createService(baseUrl);
        this.temperature = temperature;
    }

    private static IOllamaApi createService(String baseUrl) {
        return (IOllamaApi)Retrofit.builder((String)baseUrl).withNoAuthentication().withInteractionLogger(LOGGER).withReadTimeout(1200L).create(IOllamaApi.class);
    }

    @Override
    public String complete(LlmPrompt prompt) throws ServiceCallException {
        return this.service.performChatCompletion(new OllamaChatMessageDTO(this.model, prompt.getAllText(), this.temperature)).response();
    }
}

