/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerReference;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public abstract class ServerDescriptionBase
implements IOption {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="userServer")
    @OptionFieldDescription(name="Retrieve users from the following servers")
    public String userServer;

    public abstract EAuthenticationTool getAuthenticationTool();

    public abstract boolean isEmpty();

    public List<ServerReference> getUserDelegateServers() {
        return ServerReference.parse(this.userServer);
    }

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        ServerOptionIndex optionIndex = (ServerOptionIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
        Optional<String> userServerIssues = ServerReference.validate(this.userServer, optionIndex, "User server");
        return userServerIssues.orElse(null);
    }

    public static <ServerDescription extends ServerDescriptionBase> @Nullable NamedServer<ServerDescription> getServer(ServerOptionIndex optionIndex, EAuthenticationTool authenticationTool, Class<ServerDescription> descriptionClass, String serverName) throws StorageException {
        ServerDescriptionBase serverDescription = (ServerDescriptionBase)ServerOptionRegistry.getInstance().getServerMultiOption(AuthenticationToolUtils.getOptionName(authenticationTool), serverName, descriptionClass, optionIndex);
        if (serverDescription.isEmpty()) {
            return null;
        }
        return new NamedServer<ServerDescriptionBase>(serverName, serverDescription);
    }
}

