/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.crowd;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ToolAuthenticatorBase;
import com.teamscale.core.authenticate.crowd.CrowdServerDescription;
import com.teamscale.core.authenticate.crowd.CrowdUtils;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

public class CrowdAuthenticator
extends ToolAuthenticatorBase<CrowdServerDescription> {
    public static final String IDENTIFIER = CrowdAuthenticator.class.getSimpleName();
    private static final Logger LOGGER = LogManager.getLogger();

    public CrowdAuthenticator() {
        super(EAuthenticationTool.CROWD, CrowdServerDescription.class);
    }

    @Override
    public String getAuthenticatorIdentifier() {
        return IDENTIFIER;
    }

    @Override
    protected boolean authenticate(NamedServer<CrowdServerDescription> server, User user, byte[] password, ServerOptionIndex optionIndex) {
        try {
            CrowdUtils.authenticateUser(user, StringUtils.bytesToString((byte[])password), server.serverDescription());
            return true;
        }
        catch (AuthenticationToolException e) {
            LOGGER.error("Authentication failed: " + e.getMessage(), (Throwable)((Object)e));
            return false;
        }
    }
}

