/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.crowd;

import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.SynchronizeUsersStrategyBase;
import com.teamscale.core.authenticate.crowd.CrowdAuthenticator;
import com.teamscale.core.authenticate.crowd.CrowdServerDescription;
import com.teamscale.core.authenticate.crowd.CrowdUtils;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

class CrowdSynchronizeUsersStrategy
extends SynchronizeUsersStrategyBase<CrowdServerDescription> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IMessageBroker messageBroker;

    public CrowdSynchronizeUsersStrategy(NamedServer<CrowdServerDescription> server, UserIndex userIndex, IMessageBroker messageBroker) {
        super(server, userIndex);
        this.messageBroker = messageBroker;
    }

    @Override
    public Optional<String> synchronizeUser(User user) throws StorageException, AuthenticationToolException {
        Optional<User> updatedUser = CrowdUtils.updateOrImportUser(user.getUsername(), this.getServer(), this.userIndex, this.messageBroker);
        if (updatedUser.isEmpty()) {
            LOGGER.warn("User was not found on server: " + user.getUsername());
            return Optional.empty();
        }
        return Optional.of(user.getUsername());
    }

    @Override
    protected String getAuthenticatorIdentifier() {
        return CrowdAuthenticator.IDENTIFIER;
    }
}

