/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.openid;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.ISsoAuthenticatorOption;
import com.teamscale.core.authenticate.index.OAuthStateIndex;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import java.net.URI;
import java.util.Optional;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="auth.openid", name="OpenID Connect", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AUTH, orderingHint=3000)
@IndexValueClass(containedInBackup=true)
public class OpenIdAuthenticationOption
implements ISsoAuthenticatorOption {
    private static final long serialVersionUID = 1L;
    private static final String RESPONSE_TYPE = "code";
    private static final String SCOPE = UrlUtils.encodePathSegment((String)"openid email profile");
    @JsonProperty(value="displayName")
    @OptionFieldDescription(name="Display name for the login button")
    public String displayName;
    @JsonProperty(value="issuer")
    @OptionFieldDescription(name="URL to the OpenID Connect provider")
    public String issuer;
    @JsonProperty(value="authorizationEndpoint")
    @OptionFieldDescription(name="URI of the authorization endpoint")
    private String authorizationEndpoint;
    @JsonProperty(value="tokenEndpoint")
    @OptionFieldDescription(name="URI of the token endpoint")
    public String tokenEndpoint;
    @JsonProperty(value="useEndSessionEndpoint")
    @OptionFieldDescription(name="Use end session endpoint for logout. (Might not be defined for all OpenID Connect providers.)", dependentOptions={"endSessionEndpoint"})
    private boolean useEndSessionEndpoint;
    @JsonProperty(value="endSessionEndpoint")
    @OptionFieldDescription(name="URI of the end session endpoint for logout")
    private String endSessionEndpoint;
    @JsonProperty(value="redirectUri")
    @OptionFieldDescription(name="Redirect URI", description="Must be in the form of https://<your-teamscale-server>/api/auth/openid/<authenticator-id>. The authenticator id can be omitted if only one OpenID Connect is set.")
    public String redirectUri;
    @JsonProperty(value="clientId")
    @OptionFieldDescription(name="Client ID")
    public String clientId = "";
    @JsonProperty(value="clientSecret")
    @PasswordOption
    @OptionFieldDescription(name="Client secret")
    public String clientSecret = "";
    @JsonProperty(value="usernameField")
    @OptionFieldDescription(name="Username field (optional, defaults to \"sub\")")
    public String usernameField = "";
    @JsonProperty(value="autoCreateUsers")
    @OptionFieldDescription(name="Automatically create authenticated users.", dependentOptions={"newUserGroup", "userinfoEndpoint"})
    public boolean autoCreateUsers;
    @JsonProperty(value="userinfoEndpoint")
    @OptionFieldDescription(name="URI of the userinfo endpoint. If this is not provided, only information from the id token will be used when creating new users.")
    public String userinfoEndpoint;
    @JsonProperty(value="newUserGroup")
    @OptionFieldDescription(name="Default group for automatically created users.")
    private String newUserGroup;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (StringUtils.isEmpty((String)this.displayName)) {
            return "Provide value for the display name of the login button!";
        }
        if (StringUtils.isEmpty((String)this.issuer)) {
            return "Provide value for OpenID Connect provider!";
        }
        if (StringUtils.isEmpty((String)this.authorizationEndpoint)) {
            return "Provide value for authorization endpoint!";
        }
        if (StringUtils.isEmpty((String)this.tokenEndpoint)) {
            return "Provide value for token endpoint!";
        }
        if (this.useEndSessionEndpoint && StringUtils.isEmpty((String)this.endSessionEndpoint)) {
            return "Provide value for end session endpoint!";
        }
        if (StringUtils.isEmpty((String)this.redirectUri)) {
            return "Provide value for redirect URI!";
        }
        if (StringUtils.isEmpty((String)this.clientId)) {
            return "Provide value for client ID!";
        }
        if (StringUtils.isEmpty((String)this.clientSecret)) {
            return "Provide value for client secret!";
        }
        return null;
    }

    @Override
    public Optional<String> buildRedirectionLink(URI baseUri, @Nullable String redirectionTarget, String sessionToken, OAuthStateIndex oAuthStateIndex) {
        return Optional.of(this.authorizationEndpoint + "?response_type=code&scope=" + SCOPE + "&client_id=" + this.clientId + "&redirect_uri=" + this.redirectUri + "&state=" + UrlUtils.encodeQueryParameter((String)StringUtils.emptyIfNull((String)redirectionTarget)));
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public ESsoAuthenticatorType getAuthenticatorType() {
        return ESsoAuthenticatorType.OPENID_CONNECT;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public boolean getUseEndSessionEndpoint() {
        return this.useEndSessionEndpoint;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public boolean getAutoCreateUsers() {
        return this.autoCreateUsers;
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public String getNewUserGroup() {
        return this.newUserGroup;
    }

    public String getUsernameField() {
        return this.usernameField;
    }
}

