/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.saml;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.ISsoAuthenticatorOption;
import com.teamscale.core.authenticate.base.ServerReference;
import com.teamscale.core.authenticate.index.OAuthStateIndex;
import com.teamscale.core.authenticate.saml.SamlCertificateRefreshTrigger;
import com.teamscale.core.authenticate.saml.SamlConfigurationCache;
import com.teamscale.core.authenticate.saml.SamlUtils;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import jakarta.ws.rs.BadRequestException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import org.opensaml.core.config.InitializationException;

@Option(id="auth.saml", name="SAML 2.0 Identity Provider", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AUTH, orderingHint=2000)
@IndexValueClass(containedInBackup=true)
public class SamlAuthenticationOption
implements ISsoAuthenticatorOption {
    public static final String OPTION_ID = "auth.saml";
    public static final String SAML_SERVICE_BASE_PATH = "api/auth/saml/";
    public static final String SAML_AUTHENTICATION_SERVICE_PATH = "api/auth/saml/authenticate";
    private static final String ENCRYPTION_ALGORITHM = "RSA";
    private static final long serialVersionUID = 1L;
    private static KeyFactory keyFactory = null;
    @JsonProperty(value="displayName")
    @OptionFieldDescription(name="Display name of the identity provider used for the login button")
    public String displayName;
    @JsonProperty(value="serviceProviderId")
    @OptionFieldDescription(name="Id of this service provider as registered in the identity provider")
    public String serviceProviderId = "teamscale";
    @JsonProperty(value="metadataUrl")
    @OptionFieldDescription(name="Metadata URL from the identity provider")
    public String metadataUrl;
    @JsonProperty(value="metadataXml")
    @MultilineOption
    @OptionFieldDescription(name="Metadata XML as obtained from the identity provider. This should be an entity descriptor with an X.509 certificate.")
    public String metadataXml;
    @JsonProperty(value="idAttribute")
    @OptionFieldDescription(name="SAML attribute to use as Teamscale user name. If empty, the NameID will be used.")
    public String idAttribute;
    @JsonProperty(value="userAliasAttribute")
    @OptionFieldDescription(name="SAML attribute to use as Teamscale user alias (optional).")
    public String userAliasAttribute;
    @JsonProperty(value="autoCreateUsers")
    @OptionFieldDescription(name="Automatically create authenticated users.", dependentOptions={"newUserGroup", "mailAttribute", "firstNameAttribute", "lastNameAttribute", "groupServer"})
    public boolean autoCreateUsers;
    @JsonProperty(value="newUserGroup")
    @OptionFieldDescription(name="Default group for automatically created users (optional).")
    public String newUserGroup;
    @JsonProperty(value="mailAttribute")
    @OptionFieldDescription(name="SAML attribute containing the e-mail address (if any).")
    public String mailAttribute;
    @JsonProperty(value="firstNameAttribute")
    @OptionFieldDescription(name="SAML attribute containing the first name (if any).")
    public String firstNameAttribute;
    @JsonProperty(value="lastNameAttribute")
    @OptionFieldDescription(name="SAML attribute containing the last name (if any).")
    public String lastNameAttribute;
    @JsonProperty(value="groupServer")
    @OptionFieldDescription(name="Retrieve groups from the following servers.", description="During user creation, the groups are retrieved once from the provided servers.")
    public String groupServer;
    @JsonProperty(value="synchronizeGroups")
    @OptionFieldDescription(name="Synchronize SAML groups.", dependentOptions={"groupsAttribute", "groupsIncludePattern", "groupsExcludePattern"})
    public boolean synchronizeGroups;
    @JsonProperty(value="groupsAttribute")
    @OptionFieldDescription(name="SAML attribute containing the groups.")
    public String groupsAttribute = "Groups";
    @JsonProperty(value="groupsIncludePattern")
    @OptionFieldDescription(name="Regular expression describing the groups that should be considered for synchronization (leave empty for all groups).")
    public String groupsIncludePattern;
    @JsonProperty(value="groupsExcludePattern")
    @OptionFieldDescription(name="Regular expression describing the groups that should be ignored for synchronization.")
    public String groupsExcludePattern;
    @JsonProperty(value="automaticallyRegenerateCertificate")
    @OptionFieldDescription(name="Automatically renew SP certificate", description="Teamscale will automatically renew the SP certificate 60 days before its expiration.\nIt is recommended to enable this setting only if the IDP automatically and regularly fetches the Metadata XML from Teamscale.\nOtherwise, the renewal is likely to be overlooked and not communicated to the IDP.\n")
    @ScheduleOption(schedule="@midnight", triggerClass=SamlCertificateRefreshTrigger.class)
    public boolean automaticallyRegenerateCertificate = false;
    @JsonIgnore
    private byte[] privateKey;
    @JsonIgnore
    private byte[] certificate;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        Optional<String> error;
        if (StringUtils.isEmpty((String)this.displayName)) {
            return "Name of the SAML identity provider is missing!";
        }
        if (StringUtils.isEmpty((String)this.serviceProviderId)) {
            return "Name of service provider is missing!";
        }
        if (StringUtils.isEmpty((String)this.metadataXml)) {
            return "Metadata XML of the SAML identity provider is missing!";
        }
        try {
            LoggingUtils.FLICKER_DEBUG_LOGGER.debug("validate step: ensureInitialized");
            SamlUtils.ensureInitialized();
            LoggingUtils.FLICKER_DEBUG_LOGGER.debug("validate step: extractCredential");
            SamlUtils.extractCredential(this.metadataXml);
            LoggingUtils.FLICKER_DEBUG_LOGGER.debug("validate step: extractEntityId");
            SamlUtils.extractEntityId(this.metadataXml);
            LoggingUtils.FLICKER_DEBUG_LOGGER.debug("validate step: finished");
        }
        catch (BadRequestException e) {
            return "Invalid metadata: " + e.getMessage();
        }
        catch (InitializationException e) {
            return "Failed to initialize SAML subsystem: " + e.getMessage();
        }
        if (this.autoCreateUsers && (error = ServerReference.validate(this.groupServer, (ServerOptionIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class), "Group server")).isPresent()) {
            return error.get();
        }
        return this.validateGroupSynchronization().orElse(null);
    }

    public List<ServerReference> getGroupDelegateServers() {
        if (!this.autoCreateUsers) {
            return Collections.emptyList();
        }
        return ServerReference.parse(this.groupServer);
    }

    private Optional<String> validateGroupSynchronization() {
        if (!this.synchronizeGroups) {
            return Optional.empty();
        }
        if (StringUtils.isEmpty((String)this.groupsAttribute)) {
            return Optional.of("Please provide the groups attribute when activating synchronization of SAML groups.");
        }
        return SamlAuthenticationOption.validatePattern("group synchronization include pattern", this.groupsIncludePattern).or(() -> SamlAuthenticationOption.validatePattern("group synchronization exclude pattern", this.groupsExcludePattern));
    }

    private static Optional<String> validatePattern(String name, String regex) {
        if (!StringUtils.isEmpty((String)regex)) {
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                return Optional.of("Invalid pattern for " + name + ": " + e.getMessage());
            }
        }
        return Optional.empty();
    }

    @Override
    public void integrateExistingOption(IOption existingOption) {
        LoggingUtils.FLICKER_DEBUG_LOGGER.debug("integrateExistingOption step: generate certificate");
        if (existingOption == null) {
            this.generatePrivateKey();
            this.generateCertificate();
        }
        if (!(existingOption instanceof SamlAuthenticationOption)) {
            return;
        }
        SamlAuthenticationOption existingSamlAuthenticationOption = (SamlAuthenticationOption)existingOption;
        LoggingUtils.FLICKER_DEBUG_LOGGER.debug("integrateExistingOption step: extract private key");
        this.privateKey = existingSamlAuthenticationOption.privateKey;
        LoggingUtils.FLICKER_DEBUG_LOGGER.debug("integrateExistingOption step: extract certificate");
        this.certificate = existingSamlAuthenticationOption.certificate;
        LoggingUtils.FLICKER_DEBUG_LOGGER.debug("integrateExistingOption step: finished");
    }

    private void generatePrivateKey() {
        KeyPairGenerator keyGenerator;
        try {
            keyGenerator = KeyPairGenerator.getInstance(ENCRYPTION_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Expected RSA to be available!", e);
        }
        keyGenerator.initialize(2048);
        this.privateKey = keyGenerator.generateKeyPair().getPrivate().getEncoded();
    }

    @Override
    public Optional<String> buildRedirectionLink(URI baseUri, @Nullable String redirectionTarget, String sessionToken, OAuthStateIndex oAuthStateIndex) {
        return SamlConfigurationCache.getInstance().getRequestUrl(this, baseUri, redirectionTarget, sessionToken, oAuthStateIndex);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SamlAuthenticationOption)) {
            return false;
        }
        SamlAuthenticationOption other = (SamlAuthenticationOption)obj;
        return Objects.equals(this.serviceProviderId, other.serviceProviderId) && Objects.equals(this.metadataXml, other.metadataXml);
    }

    public int hashCode() {
        return Objects.hash(this.serviceProviderId, this.metadataXml);
    }

    public Optional<PrivateKey> getPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.privateKey == null) {
            return Optional.empty();
        }
        return Optional.of(SamlAuthenticationOption.getOrInstantiateKeyFactory().generatePrivate(new PKCS8EncodedKeySpec(this.privateKey)));
    }

    public Optional<PublicKey> getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        Optional<PrivateKey> optionalPrivateKey = this.getPrivateKey();
        if (optionalPrivateKey.isEmpty()) {
            return Optional.empty();
        }
        RSAPrivateCrtKey rsaPrivateKey = (RSAPrivateCrtKey)optionalPrivateKey.get();
        return Optional.of(SamlAuthenticationOption.getOrInstantiateKeyFactory().generatePublic(new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent())));
    }

    public Optional<byte[]> getCertificate() {
        return Optional.ofNullable(this.certificate);
    }

    public boolean generateCertificate() {
        Optional<Object> publicKey = Optional.empty();
        Optional<Object> privateKey = Optional.empty();
        try {
            publicKey = this.getPublicKey();
            privateKey = this.getPrivateKey();
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        if (privateKey.isPresent() && publicKey.isPresent()) {
            this.certificate = SamlUtils.createSelfSignedX509Certificate(new KeyPair((PublicKey)publicKey.get(), (PrivateKey)privateKey.get()));
            return true;
        }
        return false;
    }

    private static synchronized KeyFactory getOrInstantiateKeyFactory() throws NoSuchAlgorithmException {
        if (keyFactory == null) {
            keyFactory = KeyFactory.getInstance(ENCRYPTION_ALGORITHM);
        }
        return keyFactory;
    }

    @VisibleForTesting
    void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public ESsoAuthenticatorType getAuthenticatorType() {
        return ESsoAuthenticatorType.SAML;
    }
}

