/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.tfs;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.tfs.ITfsConnection;
import com.teamscale.core.tfs.TfsConnectionFactory;
import com.teamscale.core.tfs.TfsException;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class TfsAuthorizationUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Cache<String, Set<String>> GROUP_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    public static Set<String> getAllGroupNames(ExternalCredentials serverCredentials) throws AuthenticationToolException {
        return (Set)CollectionUtils.computeIfAbsentWithException((Map)GROUP_CACHE.asMap(), (Object)serverCredentials.uri, key -> TfsAuthorizationUtils.retrieveAllGroupNames(serverCredentials));
    }

    private static Set<String> retrieveAllGroupNames(ExternalCredentials serverCredentials) throws AuthenticationToolException {
        ITfsConnection connection = TfsConnectionFactory.createWithExternalCredentials(serverCredentials);
        try {
            Set<String> set = connection.identity().retrieveAllGroupNames();
            if (connection != null) {
                connection.close();
            }
            return set;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (TfsException e) {
                throw new AuthenticationToolException("Could not read groups from TFS server", (Throwable)((Object)e));
            }
        }
    }

    public static Optional<UserGroup> findGroupByName(ExternalCredentials serverCredentials, String serverName, String groupName) throws AuthenticationToolException {
        ITfsConnection connection = TfsConnectionFactory.createWithExternalCredentials(serverCredentials);
        try {
            Set<UserGroup> foundGroups = connection.identity().getGroupsByName(serverName, groupName);
            if (foundGroups.size() > 1) {
                LOGGER.warn("Multiple groups found for group name '%s' on remote TFS server '%s'".formatted(groupName, serverName));
            }
            Optional<UserGroup> optional = foundGroups.stream().findFirst();
            if (connection != null) {
                connection.close();
            }
            return optional;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (TfsException e) {
                throw new AuthenticationToolException("Could not retrieve group '" + groupName + "' from TFS server", (Throwable)((Object)e));
            }
        }
    }

    public static Optional<UserGroup> findGroupById(ExternalCredentials serverCredentials, String serverName, UserGroup group) throws AuthenticationToolException {
        ITfsConnection connection = TfsConnectionFactory.createWithExternalCredentials(serverCredentials);
        try {
            Optional<UserGroup> optional = connection.identity().getGroupByIdentifier(serverName, group.getRemoteGroup());
            if (connection != null) {
                connection.close();
            }
            return optional;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (TfsException e) {
                throw new AuthenticationToolException("Could not retrieve group '" + group.getRemoteGroup() + "' from TFS server", (Throwable)((Object)e));
            }
        }
    }

    public static Set<String> getUsersForGroup(ExternalCredentials serverCredentials, UserGroup group, @Nullable String userIdAttributeName) throws AuthenticationToolException {
        ITfsConnection connection = TfsConnectionFactory.createWithExternalCredentials(serverCredentials);
        try {
            Set<String> set = connection.identity().getUserIdsByGroup(group, userIdAttributeName);
            if (connection != null) {
                connection.close();
            }
            return set;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (TfsException e) {
                throw new AuthenticationToolException("Could not retrieve members of group '" + group.getRemoteGroup() + "' from TFS server", (Throwable)((Object)e));
            }
        }
    }

    public static Set<String> getGroupIdsForUser(ExternalCredentials serverCredentials, User user, String serverName) throws AuthenticationToolException {
        ITfsConnection connection = TfsConnectionFactory.createWithExternalCredentials(serverCredentials);
        try {
            Set set = CollectionUtils.mapToSet(connection.identity().getGroupsByUser(serverName, user), UserGroup::getRemoteGroup);
            if (connection != null) {
                connection.close();
            }
            return set;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (TfsException e) {
                throw new AuthenticationToolException("Could not retrieve groups of user '" + user.getUsername() + "' from TFS server", (Throwable)((Object)e));
            }
        }
    }

    private TfsAuthorizationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

