/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import java.io.Serializable;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.lang.Markdown;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@Index(name="critical-system-state", options={EStorageOption.COMPRESSED})
public class CriticalSystemStateIndex
implements IGlobalIndex {
    private static final String KEY = "status";
    private final ValueIndex<CriticalSystemStatus> delegate;

    public CriticalSystemStateIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setStatus(CriticalSystemStatus status) throws StorageException {
        this.delegate.setValue(KEY, (Object)status);
    }

    public void clearStatus() throws StorageException {
        this.delegate.removeValue(KEY);
    }

    public @Nullable CriticalSystemStatus getStatus() throws StorageException {
        return (CriticalSystemStatus)this.delegate.getValue(KEY);
    }

    @IndexValueClass
    public static class CriticalSystemStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ECriticalSystemStatusType statusType;

        private CriticalSystemStatus(ECriticalSystemStatusType statusType) {
            this.statusType = statusType;
        }

        public ECriticalSystemStatusType getStatusType() {
            return this.statusType;
        }

        public static CriticalSystemStatus createOutOfMemoryStatus() {
            return new CriticalSystemStatus(ECriticalSystemStatusType.OUT_OF_MEMORY);
        }
    }

    @IndexValueClass
    public static enum ECriticalSystemStatusType {
        OUT_OF_MEMORY("Out of Memory. Please refer to the [memory troubleshooting](https://docs.teamscale.com/troubleshooting/#teamscale-runs-into-memory-related-problems) section in the documentation.");

        @Markdown
        private final String message;

        private ECriticalSystemStatusType(String message) {
            this.message = message;
        }

        @Markdown
        public String getMessage() {
            return this.message;
        }
    }
}

