/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public record LogCount(@JsonProperty(value="debug") int debug, @JsonProperty(value="info") int info, @JsonProperty(value="warning") int warning, @JsonProperty(value="error") int error, @JsonProperty(value="fatal") int fatal) implements Serializable
{
    private static final long serialVersionUID = 1L;
    private static final String DEBUG_COUNT_PROPERTY_NAME = "debug";
    private static final String INFO_COUNT_PROPERTY_NAME = "info";
    private static final String WARNING_COUNT_PROPERTY_NAME = "warning";
    private static final String ERROR_COUNT_PROPERTY_NAME = "error";
    private static final String FATAL_ERROR_COUNT_PROPERTY_NAME = "fatal";

    public static LogCount ofZero() {
        return new LogCount(0, 0, 0, 0, 0);
    }

    public static LogCount ofDebug(int debug) {
        return new LogCount(debug, 0, 0, 0, 0);
    }

    public static LogCount ofInfo(int info) {
        return new LogCount(0, info, 0, 0, 0);
    }

    public static LogCount ofWarning(int warning) {
        return new LogCount(0, 0, warning, 0, 0);
    }

    public static LogCount ofError(int error) {
        return new LogCount(0, 0, 0, error, 0);
    }

    public static LogCount ofFatal(int fatal) {
        return new LogCount(0, 0, 0, 0, fatal);
    }

    public int errorAndFatal() {
        return this.error + this.fatal;
    }

    public int warningAndHigher() {
        return this.warning + this.error + this.fatal;
    }

    public ELogLevel getHighestLogLevel() {
        if (this.fatal > 0) {
            return ELogLevel.FATAL;
        }
        if (this.error > 0) {
            return ELogLevel.ERROR;
        }
        if (this.warning > 0) {
            return ELogLevel.WARN;
        }
        if (this.info > 0) {
            return ELogLevel.INFO;
        }
        if (this.debug > 0) {
            return ELogLevel.DEBUG;
        }
        return ELogLevel.INFO;
    }
}

