/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.LogEntryIdentifier;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public abstract class LogEntryBase
implements Comparable<LogEntryBase>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TIMESTAMP_PROPERTY_NAME = "timestamp";
    protected static final String ID_PROPERTY_NAME = "id";
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    protected static final DateTimeFormatter DATE_TIME_FORMAT_WITH_ZONE = new DateTimeFormatterBuilder().appendPattern("yyyy/MM/dd HH:mm:ss").appendLiteral(' ').appendOffset("+HH:mm", "Z").appendLiteral(' ').appendZoneText(TextStyle.SHORT).toFormatter();
    @JsonProperty(value="id")
    private LogEntryIdentifier id;

    protected LogEntryBase(LogEntryIdentifier id) {
        this.id = id;
    }

    @JsonProperty(value="timestamp")
    public long getTimestamp() {
        return this.id.timestamp();
    }

    public LogEntryIdentifier getId() {
        return this.id;
    }

    public void setId(LogEntryIdentifier id) {
        this.id = id;
    }

    public String getTimestampFormatted() {
        return DATE_TIME_FORMAT.format(DateTimeUtils.atZone((long)this.id.timestamp()));
    }

    protected String getTimestampFormattedWithZone() {
        return DATE_TIME_FORMAT_WITH_ZONE.format(DateTimeUtils.atZone((long)this.id.timestamp()));
    }

    @Override
    public int compareTo(LogEntryBase other) {
        return this.id.compareTo(other.id);
    }
}

