/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.js.ShortJavaScriptErrorLog;
import com.teamscale.core.log.profiler.ShortProfilerLog;
import com.teamscale.core.log.service.ShortCriticalEventServiceLog;
import com.teamscale.core.log.service.ShortServiceLog;
import com.teamscale.core.log.worker.ShortCriticalEventWorkerLog;
import com.teamscale.core.log.worker.ShortWorkerLog;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ShortWorkerLog.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ShortCriticalEventWorkerLog.class, name="CriticalEventShortWorkerLog"), @JsonSubTypes.Type(value=ShortCriticalEventServiceLog.class, name="ShortCriticalEventLog"), @JsonSubTypes.Type(value=ShortJavaScriptErrorLog.class, name="ShortJavaScriptErrorLog"), @JsonSubTypes.Type(value=ShortServiceLog.class, name="ShortServiceLog"), @JsonSubTypes.Type(value=ShortProfilerLog.class, name="ShortProfilerLog"), @JsonSubTypes.Type(value=ShortWorkerLog.class, name="ShortWorkerLog")})
@IndexValueClass
public abstract class ShortLogEntryBase
extends LogEntryBase {
    private static final long serialVersionUID = 1L;
    protected static final String PROJECT_NAME_PROPERTY_NAME = "projectName";
    protected static final String LOG_COUNT_PROPERTY_NAME = "logCount";
    private static final Pattern COMMIT_DESCRIPTOR_PATTERN = Pattern.compile("(\\S+)@(\\d+)");
    @JsonProperty(value="projectName")
    private @Nullable IProjectId projectId;
    @JsonProperty(value="logCount")
    private final LogCount logCount;

    protected ShortLogEntryBase(LogEntryIdentifier id, LogCount logCount, @Nullable IProjectId projectId) {
        super(id);
        this.logCount = logCount;
        this.projectId = projectId;
    }

    public @Nullable IProjectId getProjectId() {
        return this.projectId;
    }

    public void setProjectId(@Nullable PublicProjectId projectId) {
        this.projectId = projectId;
    }

    public LogCount getLogCount() {
        return this.logCount;
    }

    public final boolean matches(Pattern pattern) {
        return this.getFilterCriteria().filter(Objects::nonNull).map(pattern::matcher).anyMatch(Matcher::find);
    }

    protected Stream<String> getFilterCriteria() {
        long timestamp = this.getTimestamp();
        return Stream.of(Long.toString(timestamp), new Date(timestamp).toString());
    }

    public String getFormattedLogEntry() {
        StringBuilder logEntry = new StringBuilder();
        this.appendFields(logEntry);
        this.appendErrorStatistics(logEntry);
        return logEntry.toString();
    }

    protected void appendFields(StringBuilder builder) {
        builder.append(this.getTimestampFormatted()).append(" ");
        builder.append("(timestamp: ").append(this.getTimestamp()).append(") ");
        builder.append(this.projectId).append(" ");
    }

    protected void appendErrorStatistics(StringBuilder builder) {
        LogCount logCount = this.getLogCount();
        builder.append(logCount.fatal()).append(" fatals ");
        builder.append(logCount.error()).append(" errors ");
        builder.append(logCount.warning()).append(" warnings ");
    }

    protected static String formatTimestampsAsDates(String message) {
        Matcher commitDescriptorMatcher = COMMIT_DESCRIPTOR_PATTERN.matcher(message);
        Set timestamps = commitDescriptorMatcher.results().map(match -> Long.parseLong(match.group(2))).collect(Collectors.toSet());
        Iterator iterator = timestamps.iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            String date = DateTimeUtils.getUiFormattedDateString((long)timestamp);
            message = message.replace("@" + timestamp, "@" + timestamp + " (" + date + ")");
        }
        return message;
    }

    public LogIndexBase.EIndexLogLevel getIndexLogLevel() {
        ShortWorkerLog shortWorkerLog;
        ShortLogEntryBase shortLogEntryBase = this;
        if (shortLogEntryBase instanceof ShortWorkerLog && (shortWorkerLog = (ShortWorkerLog)shortLogEntryBase).hasFailed()) {
            return LogIndexBase.EIndexLogLevel.FATAL;
        }
        LogCount logCount = this.getLogCount();
        if (logCount.fatal() > 0) {
            return LogIndexBase.EIndexLogLevel.FATAL;
        }
        if (logCount.error() > 0) {
            return LogIndexBase.EIndexLogLevel.ERROR;
        }
        if (logCount.warning() > 0) {
            return LogIndexBase.EIndexLogLevel.WARN;
        }
        return LogIndexBase.EIndexLogLevel.INFO;
    }
}

