/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.objects.SerializedEnumLiteral;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public abstract class EnumRenameMigratorBase
extends SerializedValueMigratorBase {
    private final Map<String, String> renameMap;

    protected EnumRenameMigratorBase(boolean compressed, Map<String, String> renameMap) {
        super(compressed);
        this.renameMap = new HashMap<String, String>(renameMap);
    }

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        List enums = entityPool.getEntities(SerializedEnumLiteral.class);
        for (SerializedEnumLiteral enumLiteral : enums) {
            String newName = this.renameMap.get(enumLiteral.getLiteralName());
            if (newName == null) continue;
            enumLiteral.setLiteralName(newName);
        }
    }
}

