/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.authenticate.teamscale.HashedStoredPasswordAuthenticator;
import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKey;
import com.teamscale.core.authenticate.teamscale.accesskeys.EncryptedAccessKeyIndex;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IMultiStoreMigrator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion129AccessKeys
implements IMultiStoreMigrator {
    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V129;
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    @Override
    public Set<String> getInputStoreNames() {
        return Set.of("access-keys");
    }

    @Override
    public Set<String> getOutputStoreNames() {
        return Set.of("access-keys-encrypted");
    }

    @Override
    public void migrate(Map<String, IStore> inputStoresByName, Map<String, IStore> outputStoresByName) throws StorageException {
        ConvenientStore unmigratedAccessKeyStore = new ConvenientStore(inputStoresByName.get("access-keys"));
        ConvenientStore encryptedKeyStore = new ConvenientStore(outputStoresByName.get("access-keys-encrypted"));
        EncryptedAccessKeyIndex index = new EncryptedAccessKeyIndex((IStore)encryptedKeyStore);
        PairList accessKeysByUsername = new PairList();
        PairList allEntries = unmigratedAccessKeyStore.getEntriesStartingWith("");
        for (Pair entry : allEntries) {
            String username = StringUtils.bytesToString((byte[])((byte[])entry.getFirst()));
            AccessKey key = this.encryptKey((byte[])entry.getSecond());
            accessKeysByUsername.add((Object)username, new ArrayList<AccessKey>(List.of(key)));
        }
        index.addAccessKeys((PairList<String, ArrayList<AccessKey>>)accessKeysByUsername);
    }

    private AccessKey encryptKey(byte[] unencryptedKey) {
        HashedStoredPasswordAuthenticator authenticator = new HashedStoredPasswordAuthenticator();
        String hashedKey = authenticator.generateNewAuthenticator(unencryptedKey);
        return new AccessKey(hashedKey, 1L);
    }
}

