/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.store;

import com.teamscale.core.migration.store.BatchMigratingStore;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IBatchStorageMigrator;
import com.teamscale.core.migration.store.IMultiStoreMigrator;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import com.teamscale.core.migration.store.IStorageMigrator;
import com.teamscale.core.migration.store.MultiStoreMigratingStorageSystem;
import com.teamscale.core.migration.store.PointwiseMigratingStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.factory.IFactory;

class MigratingStorageSystem
implements IStorageSystem {
    private final List<BatchMigratingStore> batchMigratingStores = new ArrayList<BatchMigratingStore>();
    private final Map<String, MultiStoreMigratingStorageSystem> multiStoreMigratingStorageSystemByName = new HashMap<String, MultiStoreMigratingStorageSystem>();
    private final Map<String, IStorageMigrator> storageMigrators;
    private final IFactory<IStore, StorageException> tempStoreFactory;
    private final IStorageSystem targetStorageSystem;
    private final IndexSchema schema;

    protected MigratingStorageSystem(EStorageSystemVersion storageSystemVersion, IStorageSystem targetStorageSystem, IndexSchema schema, IFactory<IStore, StorageException> tempStoreFactory, Map<String, IStorageMigrator> storageMigrators) {
        this.targetStorageSystem = targetStorageSystem;
        this.tempStoreFactory = tempStoreFactory;
        this.storageMigrators = storageMigrators;
        this.schema = schema;
        storageMigrators.values().forEach(storageMigrator -> CCSMAssert.isTrue((storageMigrator.getVersion() == storageSystemVersion ? 1 : 0) != 0, () -> "Storage system version of storage migrator " + String.valueOf((Object)storageMigrator.getVersion()) + " and storage system version of the migrating storage system " + String.valueOf((Object)storageSystemVersion) + " must match "));
    }

    public void batchMigrate() throws StorageException {
        for (BatchMigratingStore batchMigratingStore : this.batchMigratingStores) {
            batchMigratingStore.batchMigrate();
        }
        for (MultiStoreMigratingStorageSystem storageSystem : this.multiStoreMigratingStorageSystemByName.values().stream().distinct().toList()) {
            storageSystem.batchMigrate();
        }
    }

    public IStore openStore(String name) throws StorageException {
        IStorageMigrator storageMigrator = this.getStorageMigrator(name);
        IStore migratedStore = storageMigrator instanceof IMultiStoreMigrator ? this.getMultiStoreMigratingStore(name, (IMultiStoreMigrator)storageMigrator) : this.getSimpleMigratingStore(name, storageMigrator);
        return migratedStore;
    }

    private IStorageMigrator getStorageMigrator(String name) {
        return this.storageMigrators.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(name) || ((IStorageMigrator)entry.getValue()).getStoreNamePattern().map(pattern -> pattern.matcher(name).matches()).orElse(false) != false).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private IStore getMultiStoreMigratingStore(String storeName, IMultiStoreMigrator multiStoreMigrator) throws StorageException {
        MultiStoreMigratingStorageSystem storageSystem = this.multiStoreMigratingStorageSystemByName.get(storeName);
        if (storageSystem == null) {
            storageSystem = new MultiStoreMigratingStorageSystem(multiStoreMigrator, this.targetStorageSystem, this.tempStoreFactory);
            for (String inputStoreName : multiStoreMigrator.getInputStoreNames()) {
                this.multiStoreMigratingStorageSystemByName.put(inputStoreName, storageSystem);
            }
        }
        return storageSystem.openStore(storeName);
    }

    private IStore getSimpleMigratingStore(String name, IStorageMigrator storageMigrator) throws StorageException {
        Object migratedStore = this.targetStorageSystem.openStore(name);
        if (storageMigrator instanceof IPointwiseStorageMigrator) {
            migratedStore = new PointwiseMigratingStore((IStore)migratedStore, (IPointwiseStorageMigrator)storageMigrator);
        } else if (storageMigrator instanceof IBatchStorageMigrator) {
            BatchMigratingStore batchMigratingStore = new BatchMigratingStore(this.tempStoreFactory, (IStore)migratedStore, name, this.schema, (IBatchStorageMigrator)storageMigrator);
            this.batchMigratingStores.add(batchMigratingStore);
            migratedStore = batchMigratingStore;
        }
        return migratedStore;
    }

    public void removeStore(String storeName) {
        throw new UnsupportedOperationException();
    }

    public int getStorageSystemId() {
        throw new UnsupportedOperationException();
    }
}

