/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.store;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistorizingStoreBase;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public abstract class SerializedValueMigratorBase
implements IPointwiseStorageMigrator {
    private final boolean compressed;
    private final ConcurrentMap<Thread, PairList<byte[], byte[]>> migratedEntriesPerThread = new ConcurrentHashMap<Thread, PairList<byte[], byte[]>>();

    protected SerializedValueMigratorBase(boolean compressed) {
        this.compressed = compressed;
    }

    @Override
    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        if (this.isHiddenKey(key)) {
            return PairList.from((Object)key, (Object)value);
        }
        try {
            PairList migratedEntries = new PairList();
            CCSMAssert.isFalse((boolean)this.migratedEntriesPerThread.containsKey(Thread.currentThread()), () -> String.format("Expected \"%s\" to not contain a value for the current thread", "migratedEntriesPerThread"));
            this.migratedEntriesPerThread.put(Thread.currentThread(), (PairList<byte[], byte[]>)migratedEntries);
            if (this.compressed) {
                value = LZ4Utils.decompress((byte[])value);
            }
            byte[] newValue = value;
            if (!HistorizingStoreBase.isDeletionValue((byte[])value)) {
                SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])this.migrateValue(value));
                this.migrate(entityPool);
                newValue = SerializedValueMigratorBase.serializeNewValue(entityPool);
            }
            if (this.compressed) {
                newValue = LZ4Utils.compress((byte[])newValue);
            }
            migratedEntries.add((Object)this.migrateKey(key), (Object)newValue);
            PairList pairList = migratedEntries;
            return pairList;
        }
        catch (MigrationException | IOException e) {
            throw new StorageException((Throwable)e);
        }
        finally {
            this.migratedEntriesPerThread.remove(Thread.currentThread());
        }
    }

    protected boolean isHiddenKey(byte[] key) {
        return false;
    }

    private static byte[] serializeNewValue(SerializedEntityPool entityPool) throws StorageException {
        try {
            return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    protected byte[] migrateKey(byte[] key) {
        return key;
    }

    protected byte[] migrateValue(byte[] value) throws StorageException {
        return value;
    }

    protected abstract void migrate(SerializedEntityPool var1) throws StorageException, IOException, MigrationException;

    protected static void renameClass(String oldName, String newName, SerializedEntityPool entityPool) {
        entityPool.renameClass(oldName, newName);
    }

    protected static void setSerialVersionUID(String className, long serialVersionUID, SerializedEntityPool entityPool) {
        SerializedClass serializedClass = entityPool.findClass(className);
        if (serializedClass != null) {
            serializedClass.setSerialVersionUid(serialVersionUID);
        }
    }

    protected void addEntryToStore(String key, SerializedEntityPool entityPool) throws StorageException {
        this.addEntryToStore(key, SerializedValueMigratorBase.serializeNewValue(entityPool));
    }

    private void addEntryToStore(String key, byte[] serializedValue) {
        byte[] serializedKey = StringUtils.stringToBytes((String)key);
        if (this.compressed) {
            serializedValue = LZ4Utils.compress((byte[])serializedValue);
        }
        ((PairList)this.migratedEntriesPerThread.get(Thread.currentThread())).add((Object)serializedKey, (Object)serializedValue);
    }
}

