/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="ts.blacklisting-option", name="Finding exclusion (False Positives and Tolerated Findings)", type=EOptionType.SERVER, category=EOptionCategory.SERVER, orderingHint=600)
@IndexValueClass(containedInBackup=true)
public class BlacklistingOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "ts.blacklisting-option";
    public static final String OPTION_NAME = "Finding exclusion (False Positives and Tolerated Findings)";
    @JsonProperty(value="disableEmptyRationale")
    @OptionFieldDescription(name="Disable empty rationale and force the user to insert at least some text")
    public boolean disableEmptyRationale = false;
    @JsonProperty(value="disableFalsePositives")
    @OptionFieldDescription(name="Disable marking findings as false positives")
    public boolean disableFalsePositives = false;
    @JsonProperty(value="disableTolerations")
    @OptionFieldDescription(name="Disable toleration of findings")
    public boolean disableTolerations = false;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        return null;
    }

    public static BlacklistingOption getBlacklistingOption(ServerOptionIndex serverOptionIndex) throws StorageException {
        BlacklistingOption result = ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, BlacklistingOption.class, serverOptionIndex);
        if (result == null) {
            return new BlacklistingOption();
        }
        return result;
    }
}

