/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.BestAssignableJobFinder;
import com.teamscale.core.runtime.impl.scheduling.JobStoreBase;
import com.teamscale.core.runtime.impl.scheduling.PreAnnouncements;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jspecify.annotations.Nullable;

public class JobQueue
extends JobStoreBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PreAnnouncements preAnnouncements;
    private final CommitDescriptorIndex commitDescriptorIndex;
    private final TriggerCache triggerCache;
    private final AssignedJobs assignedJobs;

    public JobQueue(AnalysisProgressIndexBase progressIndex, CommitDescriptorIndex commitDescriptorIndex, TriggerCache triggerCache, AssignedJobs assignedJobs) throws StorageException {
        super(progressIndex.createJobQueueSet());
        this.commitDescriptorIndex = commitDescriptorIndex;
        this.triggerCache = triggerCache;
        this.assignedJobs = assignedJobs;
        this.preAnnouncements = PreAnnouncements.create(progressIndex);
    }

    private JobQueue(JobQueue baseQueue, List<ScheduledJob> containedJobs) throws StorageException {
        super(new ProjectAnalysisProgressIndex((IStore)new InMemoryStore()).createJobQueueSet());
        this.commitDescriptorIndex = baseQueue.commitDescriptorIndex;
        this.triggerCache = baseQueue.triggerCache;
        this.assignedJobs = baseQueue.assignedJobs;
        this.preAnnouncements = baseQueue.preAnnouncements;
        for (ScheduledJob job : containedJobs) {
            super.insertJob(job);
        }
    }

    @Override
    public void insertJob(ScheduledJob job) {
        super.insertJob(job);
    }

    public void insertPreAnnouncements(String repositoryIdentifier, List<CommitDescriptor> newPreAnnouncedCommits) throws StorageException {
        this.preAnnouncements.insertPreAnnouncements(repositoryIdentifier, newPreAnnouncedCommits);
    }

    public List<CommitDescriptor> getFirstPreAnnouncedCommits() {
        return this.preAnnouncements.getFirstPreAnnouncedCommits();
    }

    public synchronized ScheduledJob extractNextAssignableJob(boolean isDeleting, SupplierWithException<Collection<JobDescriptor>, StorageException> overallAssignedJobs) throws StorageException, TriggerCompilationException {
        ScheduledJob bestJob = this.pollBestJob(isDeleting, overallAssignedJobs);
        if (bestJob != null) {
            this.removeJob(bestJob);
            this.discardPreAnnouncements(bestJob);
        }
        return bestJob;
    }

    public static boolean isPreAnnouncingTrigger(TriggerCache triggerCache, ScheduledJob job) throws TriggerCompilationException {
        return triggerCache.getTrigger(job).isPreAnnouncingTrigger();
    }

    public synchronized ScheduledJob pollBestJob(boolean isDeleting, SupplierWithException<Collection<JobDescriptor>, StorageException> overallAssignedJobs) throws TriggerCompilationException, StorageException {
        BestAssignableJobFinder jobFinder = new BestAssignableJobFinder(this.assignedJobs, this, this.triggerCache, this.commitDescriptorIndex, isDeleting, overallAssignedJobs);
        return jobFinder.findBestAssignableJob();
    }

    private void discardPreAnnouncements(ScheduledJob job) throws TriggerCompilationException {
        if (!JobQueue.isPreAnnouncingTrigger(this.triggerCache, job)) {
            return;
        }
        CommitDescriptor commit = job.getSchedulingCommit();
        if (commit == null) {
            return;
        }
        this.preAnnouncements.removePreAnnouncement(job.getTriggerName(), commit);
    }

    public synchronized boolean assignDeltaToExistingJob(AnalysisTrigger trigger, String store, long deltaId, @Nullable Long virtualStoreId, CommitDescriptor outputCommit, DurableIdGenerator idGenerator) throws StorageException {
        CCSMAssert.isNotNull((Object)outputCommit, (String)"Executed job should always have valid commit!");
        Set<ScheduledJob> jobs = this.getJobsForCommit(outputCommit);
        for (ScheduledJob existingJob : jobs) {
            boolean triggerMatches = existingJob.getTriggerName().equals(trigger.getName());
            if (!triggerMatches || !trigger.isMergeInputDeltas() && !existingJob.getInputDeltaIdsForStore(store).isEmpty()) continue;
            this.removeJob(existingJob);
            this.insertJob(existingJob.extendInputDeltaAndVirtualStore(idGenerator.getNextId(), store, deltaId, virtualStoreId));
            return true;
        }
        return false;
    }

    public synchronized Pair<Set<Long>, Set<Long>> discardScheduledJobs(CommitDescriptor preserveCommit, Map<String, Long> timestampForBranch) {
        ArrayList<ScheduledJob> jobsToPreserve = new ArrayList<ScheduledJob>();
        HashSet<Long> discardDeltaIds = new HashSet<Long>();
        HashSet<Long> preserveDeltaIds = new HashSet<Long>();
        HashSet<Long> discardVirtualStoreIds = new HashSet<Long>();
        HashSet<Long> preserveVirtualStoreIds = new HashSet<Long>();
        for (ScheduledJob job : this.getAllJobs()) {
            if (this.shouldPreserveJob(preserveCommit, timestampForBranch, job)) {
                jobsToPreserve.add(job);
                preserveDeltaIds.addAll(job.getInputDeltaIds());
                preserveVirtualStoreIds.addAll(job.getAllVirtualStoreIds());
                continue;
            }
            discardDeltaIds.addAll(job.getInputDeltaIds());
            discardVirtualStoreIds.addAll(job.getAllVirtualStoreIds());
        }
        this.preAnnouncements.rollbackTo(preserveCommit, timestampForBranch);
        this.clear();
        jobsToPreserve.forEach(this::insertJob);
        discardDeltaIds.removeAll(preserveDeltaIds);
        discardVirtualStoreIds.removeAll(preserveVirtualStoreIds);
        return Pair.createPair(discardDeltaIds, discardVirtualStoreIds);
    }

    private boolean shouldPreserveJob(CommitDescriptor preserveCommit, Map<String, Long> timestampForBranch, ScheduledJob job) {
        if (preserveCommit == null) {
            return false;
        }
        try {
            ITrigger trigger = this.triggerCache.getTrigger(job);
            return trigger.preserveInCaseOfRollback() || job.getSchedulingCommit() == null || job.getSchedulingCommit().getTimestamp() <= timestampForBranch.getOrDefault(job.getSchedulingCommit().getBranchName(), Long.MAX_VALUE);
        }
        catch (TriggerCompilationException e) {
            LOGGER.error("Failed to obtain trigger " + job.getTriggerName() + " for job " + String.valueOf(job) + " during discarding of jobs. Discarding corresponding job.", (Throwable)e);
            return false;
        }
    }

    OptionalLong getFirstBlockingPreAnnouncement(CommitDescriptor commit) {
        return this.preAnnouncements.getFirstPreAnnouncedTimestamp(commit.getBranchName());
    }

    boolean isPreAnnouncementCausedByJob(ScheduledJob job, String branchName, long firstPreAnnouncedTimestamp) {
        return this.preAnnouncements.isPreAnnouncementCausedByJob(job, branchName, firstPreAnnouncedTimestamp);
    }

    synchronized JobQueue createFilteredView(List<ScheduledJob> containedJobs) throws StorageException {
        return new JobQueue(this, containedJobs);
    }

    Map<String, Long> getFirstPreAnnouncementsByBranch() {
        return this.preAnnouncements.getFirstPreAnnouncementByBranch();
    }
}

