/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.collections.DurableSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.jspecify.annotations.Nullable;

public abstract class JobStoreBase {
    private static final Comparator<CommitDescriptor> PRECOMMIT_AWARE_BY_TIMESTAMP_COMPARATOR = Comparator.nullsFirst(Comparator.comparingInt(JobStoreBase::getPreCommitOrderingId).thenComparingLong(CommitDescriptor::getTimestamp).thenComparing(CommitDescriptor::getBranchName));
    private final DurableSet<ScheduledJob> jobs;
    private final Map<@Nullable CommitDescriptor, Set<ScheduledJob>> jobsBySchedulingCommit = new TreeMap<CommitDescriptor, Set<ScheduledJob>>(PRECOMMIT_AWARE_BY_TIMESTAMP_COMPARATOR);
    private final Map<String, Set<ScheduledJob>> jobsByTrigger = new HashMap<String, Set<ScheduledJob>>();
    private final CounterSet<Long> deltaReferenceCount = new CounterSet();
    private final CounterSet<Long> virtualStoreReferenceCount = new CounterSet();

    protected JobStoreBase(DurableSet<ScheduledJob> jobs) {
        this.jobs = jobs;
        for (ScheduledJob job : jobs) {
            this.insertIntoSecondaryDataStructures(job);
        }
    }

    public synchronized int size() {
        return this.jobs.size();
    }

    public synchronized boolean isEmpty() {
        return this.jobs.isEmpty();
    }

    public synchronized Set<ScheduledJob> getAllJobs() {
        return new HashSet<ScheduledJob>((Collection<ScheduledJob>)this.jobs);
    }

    public synchronized Collection<@Nullable CommitDescriptor> getOrderedCommits() {
        return new ArrayList<CommitDescriptor>(this.jobsBySchedulingCommit.keySet());
    }

    public synchronized Set<CommitDescriptor> getAllNonNullSchedulingCommits() {
        HashSet<CommitDescriptor> result = new HashSet<CommitDescriptor>(this.jobsBySchedulingCommit.keySet());
        result.remove(null);
        return result;
    }

    public synchronized Set<ScheduledJob> getJobsForCommit(CommitDescriptor commit) {
        return new HashSet<ScheduledJob>(this.jobsBySchedulingCommit.getOrDefault(commit, Collections.emptySet()));
    }

    public synchronized Set<ScheduledJob> getJobsForTrigger(String trigger) {
        return new HashSet<ScheduledJob>(this.jobsByTrigger.getOrDefault(trigger, Collections.emptySet()));
    }

    public synchronized boolean isUnusedDelta(long deltaId) {
        return this.deltaReferenceCount.getValue((Object)deltaId) == 0;
    }

    public synchronized boolean isUnusedVirtualStore(long virtualStoreId) {
        return this.virtualStoreReferenceCount.getValue((Object)virtualStoreId) == 0;
    }

    public synchronized boolean existsJobForCommit(String triggerName, CommitDescriptor commitDescriptor) {
        Set byCommit = this.jobsBySchedulingCommit.getOrDefault(commitDescriptor, Collections.emptySet());
        Set byTrigger = this.jobsByTrigger.getOrDefault(triggerName, Collections.emptySet());
        if (byCommit.size() < byTrigger.size()) {
            return byCommit.stream().anyMatch(job -> job.getTriggerName().equals(triggerName));
        }
        return byTrigger.stream().anyMatch(job -> Objects.equals(commitDescriptor, job.getSchedulingCommit()));
    }

    public synchronized boolean existsJobWithoutSchedulingCommit(String triggerName) {
        return this.jobsByTrigger.getOrDefault(triggerName, Collections.emptySet()).stream().map(ScheduledJob::getSchedulingCommit).anyMatch(Objects::isNull);
    }

    public synchronized boolean existsJobForTrigger(String triggerName) {
        return !this.jobsByTrigger.getOrDefault(triggerName, Collections.emptySet()).isEmpty();
    }

    public synchronized boolean existsJobForCommit(@Nullable CommitDescriptor commit) {
        return !CollectionUtils.isNullOrEmpty((Collection)this.jobsBySchedulingCommit.get(commit));
    }

    public synchronized List<ScheduledJob> getOneJobForEachTrigger() {
        ArrayList<ScheduledJob> result = new ArrayList<ScheduledJob>();
        for (Set<ScheduledJob> jobsWithSameTrigger : this.jobsByTrigger.values()) {
            if (jobsWithSameTrigger.isEmpty()) continue;
            result.add((ScheduledJob)CollectionUtils.getAny(jobsWithSameTrigger));
        }
        return result;
    }

    protected synchronized void insertJob(ScheduledJob job) {
        if (this.jobs.add((Serializable)job)) {
            this.insertIntoSecondaryDataStructures(job);
        }
    }

    private void insertIntoSecondaryDataStructures(ScheduledJob job) {
        this.jobsBySchedulingCommit.computeIfAbsent(job.getSchedulingCommit(), x -> new HashSet()).add(job);
        this.jobsByTrigger.computeIfAbsent(job.getTriggerName(), x -> new HashSet()).add(job);
        for (long id : job.getInputDeltaIds()) {
            this.deltaReferenceCount.inc((Object)id);
        }
        for (long id : job.getAllVirtualStoreIds()) {
            this.virtualStoreReferenceCount.inc((Object)id);
        }
    }

    protected synchronized boolean removeJob(ScheduledJob job) {
        if (!this.jobs.remove((Object)job)) {
            return false;
        }
        JobStoreBase.removeFromMap(job, job.getSchedulingCommit(), this.jobsBySchedulingCommit);
        JobStoreBase.removeFromMap(job, job.getTriggerName(), this.jobsByTrigger);
        for (long id : job.getInputDeltaIds()) {
            if (this.deltaReferenceCount.inc((Object)id, -1) != 0) continue;
            this.deltaReferenceCount.remove((Object)id);
        }
        for (long id : job.getAllVirtualStoreIds()) {
            if (this.virtualStoreReferenceCount.inc((Object)id, -1) != 0) continue;
            this.virtualStoreReferenceCount.remove((Object)id);
        }
        return true;
    }

    private static <T> void removeFromMap(ScheduledJob job, T key, Map<T, Set<ScheduledJob>> jobsByKey) {
        Set<ScheduledJob> jobs = jobsByKey.get(key);
        if (jobs != null) {
            jobs.remove(job);
            if (jobs.isEmpty()) {
                jobsByKey.remove(key);
            }
        }
    }

    protected synchronized void clear() {
        this.jobs.clear();
        this.jobsBySchedulingCommit.clear();
        this.jobsByTrigger.clear();
        this.deltaReferenceCount.clear();
        this.virtualStoreReferenceCount.clear();
    }

    private static int getPreCommitOrderingId(CommitDescriptor commitDescriptor) {
        if (PreCommitUtils.isPrecommitBranch(commitDescriptor.getBranchName())) {
            return 1;
        }
        return 2;
    }

    public synchronized String toString() {
        return this.jobs.toString();
    }
}

