/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.runtime.api.performance.PerformanceMetricsIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.progress.IProjectAnalysisStateChangeListener;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgress;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ProjectProgressPublisher
implements IProjectAnalysisStateChangeListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PerformanceMetricsIndex.CompletedRevisionSupport completedRevisionSupport;
    private final BranchAnalysisStateIndex branchAnalysisStateIndex;
    private final AssignedJobs assignedJobs;
    private final JobQueue jobQueue;
    private final ProjectAnalysisProgress progress;
    private Set<CommitDescriptor> previousUnfinishedCommits = new HashSet<CommitDescriptor>();
    private List<CommitDescriptor> previousFirstPreAnnouncedCommits = new ArrayList<CommitDescriptor>();
    private boolean emptyJobQueuesInInitialAnalysisReached = false;

    public ProjectProgressPublisher(PerformanceMetricsIndex.CompletedRevisionSupport completedRevisionSupport, BranchAnalysisStateIndex branchAnalysisStateIndex, AssignedJobs assignedJobs, JobQueue jobQueue, ProjectAnalysisProgress progress) {
        this.completedRevisionSupport = completedRevisionSupport;
        this.branchAnalysisStateIndex = branchAnalysisStateIndex;
        this.assignedJobs = assignedJobs;
        this.jobQueue = jobQueue;
        this.progress = progress;
        this.progress.registerProjectAnalysisStateChangeListener(this);
    }

    public void publishProgress(ScheduledJob completedJob) throws StorageException {
        HashSet unfinishedCommits = CollectionUtils.unionSet(this.assignedJobs.getAllNonNullSchedulingCommits(), (Collection[])new Collection[]{this.jobQueue.getAllNonNullSchedulingCommits()});
        List<CommitDescriptor> finishedCommits = this.progress.updateOpenAndDoneWork(unfinishedCommits, this.completedRevisionSupport);
        this.updateProjectAnalysisState(completedJob);
        this.updateBranchAnalysisStates(finishedCommits, unfinishedCommits, completedJob);
    }

    private void setAnalysisProgressLive() throws StorageException {
        this.progress.setAnalysisState(EAnalysisState.LIVE_ANALYSIS);
        this.emptyJobQueuesInInitialAnalysisReached = false;
    }

    private void updateProjectAnalysisState(ScheduledJob completedJob) throws StorageException {
        if (this.jobQueue.isEmpty() && this.assignedJobs.isEmpty()) {
            if (this.progress.getAnalysisState().isIntermediate()) {
                this.setAnalysisProgressLive();
            } else if (this.progress.getAnalysisState() == EAnalysisState.INITIAL_ANALYSIS && !SchedulingConstants.isMaintenance((IProjectId)completedJob.getJob().getInternalProjectId())) {
                if (this.emptyJobQueuesInInitialAnalysisReached) {
                    this.setAnalysisProgressLive();
                }
                this.emptyJobQueuesInInitialAnalysisReached = true;
            }
        }
    }

    private void updateBranchAnalysisStates(List<CommitDescriptor> finishedCommits, Set<CommitDescriptor> unfinishedCommits, ScheduledJob completedJob) throws StorageException {
        List<CommitDescriptor> firstPreAnnouncedCommits = this.jobQueue.getFirstPreAnnouncedCommits();
        Set<String> branchesToUpdateState = this.calculateChangedBranches(finishedCommits, unfinishedCommits, firstPreAnnouncedCommits);
        if (!branchesToUpdateState.isEmpty()) {
            this.branchAnalysisStateIndex.updateBranchAnalysisStates(branchesToUpdateState, finishedCommits, unfinishedCommits, firstPreAnnouncedCommits, completedJob);
        }
    }

    private Set<String> calculateChangedBranches(List<CommitDescriptor> finishedCommits, Set<CommitDescriptor> unfinishedCommits, List<CommitDescriptor> firstPreAnnouncedCommits) {
        HashSet<String> branchesToUpdate = new HashSet<String>();
        branchesToUpdate.addAll(CollectionUtils.map(finishedCommits, CommitDescriptor::getBranchName));
        branchesToUpdate.addAll(ProjectProgressPublisher.getBranchesOfDifferenceSet(firstPreAnnouncedCommits, this.previousFirstPreAnnouncedCommits));
        branchesToUpdate.addAll(ProjectProgressPublisher.getBranchesOfDifferenceSet(unfinishedCommits, this.previousUnfinishedCommits));
        this.previousFirstPreAnnouncedCommits = firstPreAnnouncedCommits;
        this.previousUnfinishedCommits = unfinishedCommits;
        return branchesToUpdate;
    }

    private static List<String> getBranchesOfDifferenceSet(Collection<CommitDescriptor> currentCommits, Collection<CommitDescriptor> previousCommits) {
        return CollectionUtils.map((Collection)CollectionUtils.differenceSet(currentCommits, (Collection[])new Collection[]{previousCommits}), CommitDescriptor::getBranchName);
    }

    @Override
    public void onProjectAnalysisStateChange(EAnalysisState previousState, EAnalysisState newState) {
        if (previousState == EAnalysisState.ROLLBACK_ANALYSIS && newState.isLive()) {
            try {
                Set<String> branchesInRollback = this.branchAnalysisStateIndex.getBranchesInRollback();
                for (String branch : branchesInRollback) {
                    this.branchAnalysisStateIndex.setBranchToLive(branch);
                }
            }
            catch (StorageException e) {
                LOGGER.error("Unable to update branches still in rollback to live state", (Throwable)e);
            }
        }
    }
}

