/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.util;

import java.time.Duration;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.VisibleForTesting;

public class BusyTimer {
    private static final long OBSERVED_DURATION_NANOS = Duration.ofSeconds(10L).toNanos();
    @VisibleForTesting
    Deque<Long> phaseDurations = new LinkedList<Long>();
    private boolean lastIsBusy = false;
    private boolean isInBusyPhase = false;
    @VisibleForTesting
    long busyTimeNanos = 0L;
    @VisibleForTesting
    long waitingTimeNanos = 0L;
    private long currentStartTimeNanos = 0L;

    public BusyTimer() {
        this.storeTimeAndUpdate();
    }

    public double getUtilization() {
        this.storeTimeAndUpdate();
        long overallNanos = this.busyTimeNanos + this.waitingTimeNanos;
        if (overallNanos == 0L) {
            return 0.0;
        }
        return (double)this.busyTimeNanos / (double)overallNanos;
    }

    public void beginBusyPhase() {
        this.storeTimeAndUpdate();
        this.isInBusyPhase = true;
    }

    public void beginWaitingPhase() {
        this.storeTimeAndUpdate();
        this.isInBusyPhase = false;
    }

    private synchronized void storeTimeAndUpdate() {
        long currentEndTime = this.getCurrentTime();
        if (this.currentStartTimeNanos > 0L) {
            long elapsedTime = currentEndTime - this.currentStartTimeNanos;
            if (this.isInBusyPhase == this.lastIsBusy && !this.phaseDurations.isEmpty()) {
                this.phaseDurations.addFirst(elapsedTime + this.phaseDurations.pollFirst());
            } else if (elapsedTime > 0L) {
                this.phaseDurations.addFirst(elapsedTime);
                this.lastIsBusy = this.isInBusyPhase;
            }
        }
        this.currentStartTimeNanos = currentEndTime;
        this.updateBusyAndWaitingTimes();
    }

    private synchronized void updateBusyAndWaitingTimes() {
        long busyTimeNanos = 0L;
        long waitingTimeNanos = 0L;
        Iterator<Long> iterator = this.phaseDurations.iterator();
        boolean busy = this.lastIsBusy;
        while (iterator.hasNext()) {
            long remaining = OBSERVED_DURATION_NANOS - waitingTimeNanos - busyTimeNanos;
            long amount = Math.min(iterator.next(), remaining);
            if (amount <= 0L) {
                iterator.remove();
                continue;
            }
            if (busy) {
                busyTimeNanos += amount;
            } else {
                waitingTimeNanos += amount;
            }
            busy = !busy;
        }
        this.busyTimeNanos = busyTimeNanos;
        this.waitingTimeNanos = waitingTimeNanos;
    }

    protected long getCurrentTime() {
        return System.nanoTime();
    }
}

