/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.migration.v88_project_alias.V89ProjectInfoUnmigrated;
import com.teamscale.service.admin.IProjectServiceApi;
import com.teamscale.service.admin.ProjectService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.LegacyApiUtils;
import com.teamscale.service.framework.versioning.LegacyApi;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Hidden
@LegacyApi
@Path(value="projects")
public class LegacyProjectService
extends ApiBase {
    @Context
    private ResourceContext resourceContext;

    @GET
    @RequiresNoPermission(description="Only projects visible to the user are returned in the get all queries.")
    public Object getAllProjects(@QueryParam(value="include-deleting") boolean includeDeleting, @QueryParam(value="include-reanalyzing") boolean includeReanalyzing, @QueryParam(value="detail") @DefaultValue(value="false") boolean detail) throws StorageException {
        ProjectService resource = (ProjectService)this.resourceContext.getResource(ProjectService.class);
        if (detail) {
            return resource.getAllProjectsLegacy(includeDeleting, includeReanalyzing);
        }
        return resource.getAllProjectAliasesOrIds(includeDeleting, includeReanalyzing);
    }

    @GET
    @Path(value="{projectId}")
    @RequiresNoPermission
    public Object getProject(@PathParam(value="projectId") PublicProjectId projectId, @QueryParam(value="exists") boolean exists) throws StorageException {
        ProjectService resource = (ProjectService)this.resourceContext.getResource(ProjectService.class);
        if (exists) {
            return resource.getProject((IProjectId)projectId) != null;
        }
        this.getPermissions().checkReadInProject((IProjectId)projectId);
        return resource.getProjectLegacy(projectId);
    }

    @DELETE
    @Path(value="{project}")
    @RequiresProjectPermission(value={EProjectPermission.DELETE})
    public Response deleteProject(@PathParam(value="project") PublicProjectId projectId, @QueryParam(value="force-delete") boolean forceDelete, @QueryParam(value="delete-all-assignments") boolean deleteAllAssignments, @QueryParam(value="delete-all-dashboards") boolean deleteAllDashboards) throws StorageException {
        return LegacyApiUtils.apiCallWithSuccess(ProjectService.class, (ResourceContext)this.resourceContext, resource -> resource.deleteProject((IProjectId)projectId, forceDelete, deleteAllAssignments, deleteAllDashboards, true), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[0]);
    }

    @PUT
    @Path(value="{project}")
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    public IProjectServiceApi.ProjectUpdateResult editProject(@PathParam(value="project") PublicProjectId projectId, @RequestBody V89ProjectInfoUnmigrated newProjectInfo) throws StorageException {
        return (IProjectServiceApi.ProjectUpdateResult)LegacyApiUtils.apiCallWithResult(ProjectService.class, (ResourceContext)this.resourceContext, resource -> resource.editProjectLegacy(projectId, newProjectInfo), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[0]);
    }
}

