/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.profiler;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.admin.profiler.EProfilerHealth;
import com.teamscale.index.admin.profiler.EProfilerStatus;
import com.teamscale.index.admin.profiler.ProcessInformation;
import com.teamscale.index.admin.profiler.RunningProfilerInfo;
import java.io.Serializable;
import java.time.Duration;
import java.util.UUID;
import org.conqat.lib.commons.date.DurationUtils;
import org.jspecify.annotations.Nullable;

public record RunningProfilerInfoDTO(@JsonProperty(value="profilerId") UUID profilerId, @JsonProperty(value="processInformation") ProcessInformation processInformation, @JsonProperty(value="configurationId") String configurationId, @JsonProperty(value="lastHeartbeatTimestamp") long lastHeartbeatTimestamp, @JsonProperty(value="status") EProfilerStatus status, @JsonProperty(value="health") EProfilerHealth health, @JsonProperty(value="failureMessage") @Nullable String failureMessage) implements Serializable
{
    private static final Duration OFFLINE_THRESHOLD = Duration.ofSeconds(90L);

    public RunningProfilerInfoDTO(RunningProfilerInfo indexValue) {
        this(indexValue.id(), indexValue.profilerInfo().processInformation(), indexValue.profilerInfo().profilerConfiguration().configurationId(), indexValue.lastHeartbeatTimestamp(), RunningProfilerInfoDTO.getStatus(indexValue), indexValue.health(), indexValue.failureMessage());
    }

    private static EProfilerStatus getStatus(RunningProfilerInfo indexValue) {
        if (indexValue.hasShutDown()) {
            return EProfilerStatus.SHUTDOWN;
        }
        if (DurationUtils.elapsed((Duration)OFFLINE_THRESHOLD, (long)indexValue.lastHeartbeatTimestamp())) {
            return EProfilerStatus.OFFLINE;
        }
        return EProfilerStatus.ONLINE;
    }
}

