/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.benchmark;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import java.util.Optional;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="benchmark.metadata", name="Metadata for the project to be used in the benchmark", type=EOptionType.PROJECT, category=EOptionCategory.BENCHMARK_METADATA, visibilityFeatureToggle=EFeatureToggle.AUDIT_FEATURES)
@IndexValueClass(containedInBackup=true)
public class BenchmarkMetaDataOption
implements IOption {
    public static final String OPTION_ID = "benchmark.metadata";
    public static final String OPTION_NAME = "Metadata for the project to be used in the benchmark";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="organization")
    @OptionFieldDescription(name="The name of the organization or company responsible for the development of this project")
    public String organization = "";
    @JsonProperty(value="domain")
    @OptionFieldDescription(name="The name of the domain the software system and/or the organization or company developing it belong to")
    public String domain = "";
    @JsonProperty(value="openSource")
    @OptionFieldDescription(name="The code in this project is open source")
    public boolean openSource = false;
    @JsonProperty(value="qualityControlled")
    @OptionFieldDescription(name="The project is developed adhering to a Quality Control process.")
    public boolean qualityControlled = false;

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        return null;
    }

    public static Optional<BenchmarkMetaDataOption> getBenchmarkMetaData(ProjectOptionIndex projectOptionIndex) throws StorageException {
        BenchmarkMetaDataOption benchmarkMetaDataOption = (BenchmarkMetaDataOption)ProjectOptionRegistry.getInstance().getOption("<p>", OPTION_ID, null, BenchmarkMetaDataOption.class, (OptionIndexBase)projectOptionIndex);
        CCSMAssert.isNotNull((Object)benchmarkMetaDataOption);
        if (StringUtils.isEmpty((String)benchmarkMetaDataOption.organization) && StringUtils.isEmpty((String)benchmarkMetaDataOption.domain)) {
            return Optional.empty();
        }
        return Optional.of(benchmarkMetaDataOption);
    }
}

