/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.benchmark;

import com.teamscale.core.permissions.PermissionLookup;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.audit.benchmark.MetricBenchmarkComputation;
import com.teamscale.service.audit.benchmark.ProjectBenchmarkDownloadService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/audit/metric-benchmark")
public class MetricBenchmarkService
extends ApiBase {
    @GET
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    @Operation(summary="Get benchmark results", description="Returns (partly anonymized) benchmark results for a specific metric.")
    public List<ProjectBenchmarkDownloadService.BenchmarkResult> getMetricBenchmark(@Parameter(description="The metric used for the benchmark.", required=true) @QueryParam(value="metric-name") String metricName, @Parameter(description="The anonymized project ids considered for the benchmark.") @QueryParam(value="anonymized-projects") List<PublicProjectId> anonymizedProjectIds, @Parameter(description="The non-anonymized project ids considered for the benchmark.") @QueryParam(value="projects") List<PublicProjectId> nonAnonymizedProjectIds) throws StorageException {
        MetricBenchmarkComputation computationLogic = new MetricBenchmarkComputation(this.serviceInfo, (PermissionLookup<EProjectPermission>)this.getPermissions().getProjectPermissionLookup());
        return computationLogic.getBenchmarkResults(metricName, nonAnonymizedProjectIds, anonymizedProjectIds);
    }
}

