/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation;

import com.teamscale.service.documentation.layout.Layouter;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class DocumentationNodeBase<C extends DocumentationNodeBase<?>> {
    protected final String readableName;
    protected final String description;

    public DocumentationNodeBase(String readableName, String description) {
        this.readableName = readableName;
        this.description = description;
    }

    protected abstract List<C> getChildren();

    public String layout(Layouter layouter) {
        this.layoutPrefix(layouter);
        this.layoutStart(layouter);
        this.layoutChildren(layouter);
        this.layoutEnd(layouter);
        return layouter.getLayoutedText();
    }

    protected void layoutPrefix(Layouter layouter) {
    }

    protected void layoutStart(Layouter layouter) {
    }

    protected void layoutChildren(Layouter layouter) {
        if (!this.hasChildren()) {
            return;
        }
        List sortedChildren = CollectionUtils.sort(this.getChildren(), (o1, o2) -> o1.compareTo(o2));
        for (DocumentationNodeBase child : sortedChildren) {
            child.layout(layouter);
        }
    }

    protected void layoutEnd(Layouter layouter) {
    }

    protected boolean hasChildren() {
        return !CollectionUtils.isNullOrEmpty(this.getChildren());
    }

    protected <T extends DocumentationNodeBase<?>> int compareTo(T o) {
        return this.readableName.compareTo(o.readableName);
    }
}

