/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.user.User;
import com.teamscale.index.findings.calculation.ExtendedTrackedFindingUtils;
import com.teamscale.index.findings.calculation.FilteredFindingsList;
import com.teamscale.index.findings.calculation.FindingFilterUtils;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.FindingsFilterSettings;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.FindingBlacklistIndexLastChangeContributor;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.QueryServiceBase;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, FindingBlacklistIndexLastChangeContributor.class})
public abstract class FilteredFindingsServiceBase
extends ApiBase {
    protected FilteredFindingsList retrieveFilteredFindings(UniformPath uniformPath, FindingsFilterSettings findingsFilterSettings) throws StorageException {
        CommitDescriptor commitDescriptor = this.resolve(findingsFilterSettings.getCommit());
        FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(this.serviceInfo.getPrimaryPublicId(), (ProjectStorageSystem)this.getProjectStorageSystem(), this.getIndexLayer());
        IFindingsRetriever findingsRetriever = IFindingsRetriever.getFindingsRetriever((boolean)findingsFilterSettings.isOnlySpecItemFindings(), (boolean)uniformPath.isNonCodePath(), (String)commitDescriptor.getBranchName(), (FindingsCalculationInfo)calculationInfo);
        List findings = findingsRetriever.getFindings(uniformPath.toString(), commitDescriptor);
        Map blacklistLookup = findingsRetriever.getFlaggedFindings((Collection)findings, commitDescriptor);
        List extendedFindings = ExtendedTrackedFindingUtils.fromTrackedFindings((List)findings, (FindingsCalculationInfo)calculationInfo, (Map)blacklistLookup);
        return QueryServiceBase.performQueryErrorHandling(findingsFilterSettings.getSpecItemQuery(), () -> FindingFilterUtils.applyFindingFilter((UniformPath)uniformPath, (FindingsFilterSettings)findingsFilterSettings, (CommitDescriptor)commitDescriptor, (List)extendedFindings, (FindingsCalculationInfo)calculationInfo, (User)this.serviceInfo.getUser()));
    }
}

