/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import com.teamscale.service.findings.FindingsIntroductionRemovalServiceBase;
import com.teamscale.service.findings.IFindingsServiceApi;
import com.teamscale.service.resource.compare.DiffInputDescription;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.NumbersAwareStringComparator;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/projects/{project}/findings/{id}")
public class FindingsService
extends FindingsIntroductionRemovalServiceBase
implements IFindingsServiceApi {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public TrackedFinding getFinding(String findingId, UnresolvedCommitDescriptor commit) throws StorageException {
        return this.findFinding(findingId, this.resolve(commit));
    }

    @Override
    public FindingsIntroductionRemovalServiceBase.TrackedFindingWithDiffInfo getFindingWithDiffInfo(String findingId, UnresolvedCommitDescriptor commit) throws StorageException {
        CommitDescriptor resolvedCommit = this.resolve(commit);
        TrackedFinding finding = this.findFinding(findingId, resolvedCommit);
        String branchName = resolvedCommit.getBranchName();
        CommitDescriptor branchHead = CommitDescriptor.latestOnBranch((String)branchName);
        TrackedFinding headFinding = this.findFinding(findingId, branchHead);
        FindingsIntroductionRemovalServiceBase.TrackedFindingWithDiffInfo findingWithDiff = this.createFindingWithDiffInfo(headFinding);
        return FindingsService.mergeFindingsWithDiffInfo(findingWithDiff, finding);
    }

    @Override
    public List<TrackedFinding> getFindingSiblings(String findingId, UnresolvedCommitDescriptor commit) throws StorageException {
        CommitDescriptor resolvedCommit = this.resolve(commit);
        TrackedFinding finding = this.findFinding(findingId, resolvedCommit);
        if (finding.getSiblingLocations() == null || finding.getSiblingLocations().isEmpty()) {
            return Collections.emptyList();
        }
        return this.getSiblings(finding, resolvedCommit);
    }

    private TrackedFinding findFinding(String findingId, CommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        TrackedFindingsByIdIndex index = this.openProjectIndex(TrackedFindingsByIdIndex.class, historyAccessOption);
        TrackedFinding finding = index.getFinding(findingId);
        if (finding == null) {
            throw new NotFoundException("No finding with ID " + findingId + " at " + commit.toServiceCallFormat());
        }
        return finding;
    }

    private static FindingsIntroductionRemovalServiceBase.TrackedFindingWithDiffInfo mergeFindingsWithDiffInfo(FindingsIntroductionRemovalServiceBase.TrackedFindingWithDiffInfo findingWithDiff, TrackedFinding finding) {
        return new FindingsIntroductionRemovalServiceBase.TrackedFindingWithDiffInfo(TrackedFinding.Builder.from((TrackedFinding)finding).withDeathCommit(findingWithDiff.getDeathCommit()).build(), (Pair<DiffInputDescription, Boolean>)new Pair((Object)findingWithDiff.getCreationDiff(), (Object)findingWithDiff.isCreatedByOtherChange()), (Pair<DiffInputDescription, Boolean>)new Pair((Object)findingWithDiff.getRemovalDiff(), (Object)findingWithDiff.isRemovedByOtherChange()));
    }

    private List<TrackedFinding> getSiblings(TrackedFinding mainFinding, CommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        List<String> distinctSiblingUniformPaths = mainFinding.getSiblingLocations().stream().map(ElementLocation::getUniformPath).distinct().toList();
        List findingsByUniformPaths = this.openProjectIndex(TrackedFindingsIndex.class, historyAccessOption).getFindings(UniformPathCompatibilityUtil.convertCollection(distinctSiblingUniformPaths));
        ListMap findingsByLocation = new ListMap();
        findingsByUniformPaths.stream().flatMap(Collection::stream).forEach(finding -> findingsByLocation.add((Object)finding.getLocation(), finding));
        ArrayList<TrackedFinding> siblings = new ArrayList<TrackedFinding>();
        for (ElementLocation siblingLocation : mainFinding.getSiblingLocations()) {
            TrackedFinding sibling = FindingsService.findSibling((List)findingsByLocation.getCollectionOrEmpty((Object)siblingLocation), mainFinding);
            if (sibling == null) {
                LOGGER.warn("Could not find sibling of " + mainFinding.getId() + " at " + String.valueOf(siblingLocation));
                continue;
            }
            siblings.add(sibling);
        }
        return CollectionUtils.sort(siblings, Comparator.comparing(DetachedFinding::getLocationPathString, NumbersAwareStringComparator.INSTANCE));
    }

    @VisibleForTesting
    static TrackedFinding findSibling(List<TrackedFinding> findings, TrackedFinding originalFinding) {
        List potentialMatches = CollectionUtils.filter(findings, finding -> "simulink-generated-code".equals(originalFinding.getFindingIndexPartition()) || "simulink-generated-code".equals(finding.getFindingIndexPartition()) || finding.getFindingIndexPartition().equals(originalFinding.getFindingIndexPartition()));
        if (potentialMatches.isEmpty()) {
            return null;
        }
        return Collections.min(potentialMatches, Comparator.comparingInt(finding -> StringUtils.editDistance((String)originalFinding.getMessage(), (String)finding.getMessage())));
    }
}

