/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.refactoring;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.service.findings.refactoring.Method;
import com.teamscale.service.findings.refactoring.RefactoringAnalysisException;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;

public class DataflowAnalyzer {
    public static Set<String> getUsedButNotDefinedVariableIdentifiers(List<ShallowEntity> block, Method method) {
        return DataflowAnalyzer.getReadsBeforeWritesInBlockFromEntities(method, DataflowAnalyzer.obtainStatementsInBlock(block));
    }

    public static Set<String> getReadsBeforeWritesInBlockFromEntities(Method method, List<ShallowEntity> statementsInBlock) {
        IToken token;
        Map<IToken, ControlFlowNode> tokenNodeMap = method.getTokenNodeMap();
        CCSMAssert.isTrue((!statementsInBlock.isEmpty() ? 1 : 0) != 0, (String)"Expected non-empty list of statements");
        ShallowEntity firstStatementInBlock = statementsInBlock.get(0);
        ShallowEntity equivalentEntityFromMethod = method.getEntity();
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listAllEntities((Collection)method.getEntity().getChildren())) {
            if (entity.getStartLine() != firstStatementInBlock.getStartLine() || entity.getEndLine() != firstStatementInBlock.getEndLine()) continue;
            equivalentEntityFromMethod = entity;
            break;
        }
        ControlFlowNode firstNodeInBlock = null;
        UnmodifiableIterator unmodifiableIterator = equivalentEntityFromMethod.ownStartTokens().iterator();
        while (unmodifiableIterator.hasNext() && (firstNodeInBlock = tokenNodeMap.get(token = (IToken)unmodifiableIterator.next())) == null) {
        }
        if (firstNodeInBlock == null) {
            return new HashSet<String>();
        }
        return DataflowAnalyzer.getReadsBeforeWritesInBlockFromNode(statementsInBlock, firstNodeInBlock);
    }

    public static Set<String> getReadsBeforeWritesAfterBlock(Method method, List<ShallowEntity> statementsInBlock) throws RefactoringAnalysisException {
        ControlFlowNode successingControlFlowNode = DataflowAnalyzer.getFollowingControlFlowNode(method, statementsInBlock);
        return DataflowAnalyzer.getReadsBeforeWritesFrom(successingControlFlowNode);
    }

    public static Set<String> getWritesInFragment(Method method, List<ShallowEntity> statementsInBlock) {
        List statementsInMethod = ShallowParsingUtils.getStatements((ShallowEntity)method.getEntity());
        HashSet blockStatements = new HashSet(ShallowEntityTraversalUtils.getAllEntities(statementsInBlock));
        HashSet<String> writesInFragment = new HashSet<String>();
        if (blockStatements.isEmpty()) {
            return writesInFragment;
        }
        for (ShallowEntity statement : statementsInMethod) {
            if (!statement.getSubtype().equals("simple statement") && !statement.getSubtype().equals("local variable") || !blockStatements.contains(statement)) continue;
            DataflowAnalyzer.addWritesInStatement(statement, method, writesInFragment);
        }
        return writesInFragment;
    }

    private static LinkedHashSet<ControlFlowNode> getControlFlowNodes(ShallowEntity statement, Method method) {
        Map<IToken, ControlFlowNode> tokenNodeMap = method.getTokenNodeMap();
        LinkedHashSet<ControlFlowNode> nodes = new LinkedHashSet<ControlFlowNode>();
        for (IToken tokenInStatement : statement.ownStartTokens()) {
            ControlFlowNode correspondingNode = tokenNodeMap.get(tokenInStatement);
            if (correspondingNode == null) continue;
            nodes.add(correspondingNode);
        }
        return nodes;
    }

    private static boolean isNodeContainedInBlock(ControlFlowNode node, List<ShallowEntity> statementsInBlock) {
        if (node.isAssumeNode()) {
            return true;
        }
        List successorTokens = node.getTokens();
        if (successorTokens.isEmpty()) {
            return false;
        }
        int successorEndOffset = ((IToken)successorTokens.get(0)).getEndOffset();
        CCSMAssert.isTrue((!statementsInBlock.isEmpty() ? 1 : 0) != 0, (String)"Expected non-empty list of statements!");
        return statementsInBlock.get(0).getStartOffset() <= successorEndOffset && successorEndOffset <= statementsInBlock.get(statementsInBlock.size() - 1).getEndOffset();
    }

    private static ControlFlowNode getFollowingControlFlowNode(Method method, List<ShallowEntity> statementsInBlock) throws RefactoringAnalysisException {
        CCSMAssert.isTrue((!statementsInBlock.isEmpty() ? 1 : 0) != 0, (String)"Expected non-empty list of statements!");
        Map<IToken, ControlFlowNode> tokenNodeMap = method.getTokenNodeMap();
        Pair<ShallowEntity, ControlFlowNode> lastControlFlow = DataflowAnalyzer.findLastControlFlowEntity(tokenNodeMap, statementsInBlock);
        ShallowEntity lastControlFlowEntity = (ShallowEntity)lastControlFlow.getFirst();
        ControlFlowNode lastControlFlowNode = (ControlFlowNode)lastControlFlow.getSecond();
        if (lastControlFlowNode == null) {
            throw new RefactoringAnalysisException("Expected to find a corresponding ControlFlowNode for at least " + String.valueOf(lastControlFlowEntity));
        }
        while (ShallowParsingUtils.isSubpartOfBranchingStatement((ShallowEntity)lastControlFlowEntity)) {
            UnmodifiableList children = lastControlFlowEntity.getChildren();
            if (!children.isEmpty()) {
                lastControlFlowEntity = (ShallowEntity)children.getLast();
                lastControlFlowNode = DataflowAnalyzer.findNodeForEntity(tokenNodeMap, lastControlFlowEntity);
                if (lastControlFlowNode != null) continue;
                throw new RefactoringAnalysisException("Did not find matching control flow node for entity!");
            }
            return DataflowAnalyzer.findSuccessorForEmptySubpartOfBranchingStatement(tokenNodeMap, lastControlFlowEntity);
        }
        if (ShallowParsingUtils.isLoop((ShallowEntity)lastControlFlowEntity)) {
            return DataflowAnalyzer.getSuccessorAfterLoop(lastControlFlowEntity, lastControlFlowNode);
        }
        return (ControlFlowNode)lastControlFlowNode.getSuccessors().get(0);
    }

    private static Pair<ShallowEntity, ControlFlowNode> findLastControlFlowEntity(Map<IToken, ControlFlowNode> tokenNodeMap, List<ShallowEntity> entities) {
        ShallowEntity lastControlFlowEntity = entities.get(entities.size() - 1);
        ControlFlowNode lastControlFlowNode = null;
        for (int statementIndex = entities.size() - 1; statementIndex >= 0 && (lastControlFlowNode = DataflowAnalyzer.findNodeForEntity(tokenNodeMap, lastControlFlowEntity = entities.get(statementIndex))) == null; --statementIndex) {
        }
        return Pair.createPair((Object)lastControlFlowEntity, lastControlFlowNode);
    }

    private static ControlFlowNode findSuccessorForEmptySubpartOfBranchingStatement(Map<IToken, ControlFlowNode> tokenNodeMap, ShallowEntity lastEntity) throws AssertionError {
        ShallowEntity subsequentEntity = ShallowEntityTraversalUtils.getSubsequentEntity((ShallowEntity)lastEntity);
        CCSMAssert.isNotNull((Object)subsequentEntity, (String)("There was no subsequent entity for " + lastEntity.toString()));
        while (ShallowParsingUtils.isSubpartOfBranchingStatement((ShallowEntity)subsequentEntity)) {
            UnmodifiableList children = subsequentEntity.getChildren();
            if (children.size() > 0) {
                subsequentEntity = (ShallowEntity)children.get(0);
                continue;
            }
            return DataflowAnalyzer.findSuccessorForEmptySubpartOfBranchingStatement(tokenNodeMap, subsequentEntity);
        }
        return tokenNodeMap.get(subsequentEntity.includedTokens().get(0));
    }

    private static ControlFlowNode getSuccessorAfterLoop(ShallowEntity lastEntity, ControlFlowNode lastNode) {
        if ("for".equals(lastEntity.getSubtype()) || "foreach".equals(lastEntity.getSubtype())) {
            ControlFlowNode conditionalOrSyntheticNode = (ControlFlowNode)lastNode.getSuccessors().get(0);
            CCSMAssert.isTrue((conditionalOrSyntheticNode.isConditional() || conditionalOrSyntheticNode.isSynthetic() ? 1 : 0) != 0, (String)"Expected FOR or FOREACH statement to have a conditional or synthetic node as first successor!");
            return conditionalOrSyntheticNode.getNoBranch();
        }
        CCSMAssert.isTrue((boolean)"while".equals(lastEntity.getSubtype()), (String)"Expected no other statement types than FOR, FOREACH or WHILE!");
        if (lastNode.getSuccessors().size() > 1) {
            return lastNode.getNoBranch();
        }
        return (ControlFlowNode)lastNode.getSuccessors().get(0);
    }

    private static ControlFlowNode findNodeForEntity(Map<IToken, ControlFlowNode> tokenNodeMap, ShallowEntity entity) throws AssertionError {
        UnmodifiableList ownStartTokens = entity.ownStartTokens();
        CCSMAssert.isTrue((!ownStartTokens.isEmpty() ? 1 : 0) != 0, (String)"Expected to have at least one token for the last entity!");
        for (int tokenIndex = ownStartTokens.size() - 1; tokenIndex >= 0; --tokenIndex) {
            IToken candidateToken = (IToken)ownStartTokens.get(tokenIndex);
            ControlFlowNode node = tokenNodeMap.get(candidateToken);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private static Set<String> getReadsBeforeWritesInBlockFromNode(List<ShallowEntity> statementsInBlock, ControlFlowNode firstNodeInBlock) {
        HashSet readsBeforeWrites = new HashSet();
        HashSet<String> writes = new HashSet<String>();
        IdentityHashSet seen = new IdentityHashSet();
        VariableReadWriteInfo variable = firstNodeInBlock.getReadWriteInfo();
        DataflowAnalyzer.handleReadsInStatement(variable, readsBeforeWrites, writes);
        DataflowAnalyzer.handleWritesInStatement(variable, readsBeforeWrites, writes);
        CCSMAssert.isTrue((!statementsInBlock.isEmpty() ? 1 : 0) != 0, (String)"Expected a non-empty list of statements!");
        for (ControlFlowNode successor : firstNodeInBlock.getSuccessors()) {
            if (!DataflowAnalyzer.isNodeContainedInBlock(successor, statementsInBlock) || !seen.add((Object)successor)) continue;
            readsBeforeWrites = CollectionUtils.unionSet(readsBeforeWrites, (Collection[])new Collection[]{DataflowAnalyzer.getReadsBeforeWritesInBlockFromNode(successor, statementsInBlock, readsBeforeWrites, writes, (IdentityHashSet<ControlFlowNode>)seen)});
        }
        return readsBeforeWrites;
    }

    private static Set<String> getReadsBeforeWritesInBlockFromNode(ControlFlowNode start, List<ShallowEntity> statementsInBlock, Set<String> readsBeforeWrites, Set<String> writes, IdentityHashSet<ControlFlowNode> seen) {
        VariableReadWriteInfo variable = start.getReadWriteInfo();
        DataflowAnalyzer.handleReadsInStatement(variable, readsBeforeWrites, writes);
        DataflowAnalyzer.handleWritesInStatement(variable, readsBeforeWrites, writes);
        HashSet<Set<String>> followingReadsBeforeWrites = new HashSet<Set<String>>();
        CCSMAssert.isTrue((!statementsInBlock.isEmpty() ? 1 : 0) != 0, (String)"Expected a non-empty list of statements!");
        for (ControlFlowNode controlFlowNode : start.getSuccessors()) {
            if (!DataflowAnalyzer.isNodeContainedInBlock(controlFlowNode, statementsInBlock) || !seen.add((Object)controlFlowNode)) continue;
            followingReadsBeforeWrites.add(DataflowAnalyzer.getReadsBeforeWritesInBlockFromNode(controlFlowNode, statementsInBlock, readsBeforeWrites, new HashSet<String>(writes), (IdentityHashSet<ControlFlowNode>)seen.clone()));
        }
        for (Set set : followingReadsBeforeWrites) {
            readsBeforeWrites = CollectionUtils.unionSet((Collection)readsBeforeWrites, (Collection[])new Collection[]{set});
        }
        return readsBeforeWrites;
    }

    private static void handleWritesInStatement(VariableReadWriteInfo variable, Set<String> readsBeforeWrites, Set<String> writes) {
        String read;
        for (VariableWrite variableWrite : variable.getAssignments()) {
            if (!variableWrite.getType().equals((Object)VariableWrite.EVariableWriteType.OTHER)) {
                writes.add(variableWrite.getChangedVariable());
            }
            if ((read = variableWrite.getValueVariable()) == null || writes.contains(read)) continue;
            readsBeforeWrites.add(read);
        }
        for (VariableWrite variableWrite : variable.getDefinitions()) {
            writes.add(variableWrite.getChangedVariable());
            read = variableWrite.getValueVariable();
            if (read == null || writes.contains(read)) continue;
            readsBeforeWrites.add(read);
        }
    }

    private static void handleReadsInStatement(VariableReadWriteInfo variable, Set<String> readsBeforeWrites, Set<String> writes) {
        for (String read : variable.getReads()) {
            if (read == null || writes.contains(read)) continue;
            readsBeforeWrites.add(read);
        }
    }

    private static Set<String> getReadsBeforeWritesFrom(ControlFlowNode start) throws NeverThrownRuntimeException {
        HashSet<String> readsBeforeWrites = new HashSet<String>();
        HashSet<String> writes = new HashSet<String>();
        IdentityHashSet seen = new IdentityHashSet();
        return DataflowAnalyzer.getReadsBeforeWritesFrom(start, readsBeforeWrites, writes, (IdentityHashSet<ControlFlowNode>)seen);
    }

    private static Set<String> getReadsBeforeWritesFrom(ControlFlowNode start, Set<String> readsBeforeWrites, Set<String> writes, IdentityHashSet<ControlFlowNode> seen) {
        VariableReadWriteInfo variable = start.getReadWriteInfo();
        DataflowAnalyzer.handleReadsInStatement(variable, readsBeforeWrites, writes);
        DataflowAnalyzer.handleWritesInStatement(variable, readsBeforeWrites, writes);
        HashSet<Set<String>> followingReadsBeforeWrites = new HashSet<Set<String>>();
        for (ControlFlowNode controlFlowNode : start.getSuccessors()) {
            if (!seen.add((Object)controlFlowNode)) continue;
            followingReadsBeforeWrites.add(DataflowAnalyzer.getReadsBeforeWritesFrom(controlFlowNode, readsBeforeWrites, new HashSet<String>(writes), (IdentityHashSet<ControlFlowNode>)seen.clone()));
        }
        for (Set set : followingReadsBeforeWrites) {
            readsBeforeWrites = CollectionUtils.unionSet((Collection)readsBeforeWrites, (Collection[])new Collection[]{set});
        }
        return readsBeforeWrites;
    }

    private static List<VariableReadWriteInfo> getVariableReadWriteInfos(ShallowEntity statement, Method method) {
        LinkedHashSet<ControlFlowNode> nodes = DataflowAnalyzer.getControlFlowNodes(statement, method);
        ArrayList<VariableReadWriteInfo> variableReadWriteInfos = new ArrayList<VariableReadWriteInfo>();
        for (ControlFlowNode node : nodes) {
            variableReadWriteInfos.add(node.getReadWriteInfo());
        }
        return variableReadWriteInfos;
    }

    private static void addWritesInStatement(ShallowEntity statement, Method method, Set<String> writesInFragment) {
        for (VariableReadWriteInfo variable : DataflowAnalyzer.getVariableReadWriteInfos(statement, method)) {
            for (VariableWrite variableWrite : variable.getAssignments()) {
                if (variableWrite == null) continue;
                writesInFragment.add(variableWrite.getChangedVariable());
            }
            for (VariableWrite variableWrite : variable.getDefinitions()) {
                if (variableWrite == null || writesInFragment.contains(variableWrite.getChangedVariable())) continue;
                writesInFragment.add(variableWrite.getChangedVariable());
            }
        }
    }

    private static List<ShallowEntity> obtainStatementsInBlock(List<ShallowEntity> block) {
        ArrayList<ShallowEntity> statementsInBlock = new ArrayList<ShallowEntity>();
        for (ShallowEntity blockEntity : block) {
            statementsInBlock.addAll(ShallowParsingUtils.getStatements((ShallowEntity)blockEntity));
        }
        return statementsInBlock;
    }
}

