/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.github;

import com.google.common.collect.ImmutableList;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.client.GitHubAppClient;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndexSynchronizer;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import com.teamscale.service.github.GitHubServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/github")
public class GitHubAppInstallationsService
extends GitHubServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Collect URLs of all installed GitHub Apps.", description="Returns URLs by setup GitHub Apps.", tags={"Repositories"})
    @RequiresComplexPermission(value=EComplexPermission.MAY_CONFIGURE_PROJECTS)
    @Path(value="urls")
    public String[] getGitHubAppUrls() throws StorageException {
        return (String[])this.getGitHubApplicationDescriptions().stream().map(app -> app.serverUrl).distinct().toArray(String[]::new);
    }

    @GET
    @Operation(summary="Get Repositories the GitHub App has Access to", description="Returns list of repositories of the installed GitHub App.", tags={"Repositories"})
    @RequiresComplexPermission(value=EComplexPermission.MAY_CONFIGURE_PROJECTS)
    @Path(value="repositories")
    public String[] getGitHubAppInstallationRepositories(@QueryParam(value="appId") String appId) throws StorageException, ServiceCallException {
        GitHubInstallationIndex gitHubInstallationIndex = this.openGlobalIndex(GitHubInstallationIndex.class);
        GitHubAppClient githubAppClient = this.getGithubAppClient(appId);
        GitHubInstallationIndexSynchronizer.performSynchronisationWithAppSpecificClient((GitHubInstallationIndex)gitHubInstallationIndex, (GitHubAppClient)githubAppClient, (Logger)LOGGER);
        Set installationIds = gitHubInstallationIndex.getInstallationIdsForAppId(Long.valueOf(Long.parseLong(appId)));
        ArrayList<String> repositoryNames = new ArrayList<String>();
        Iterator iterator = installationIds.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            repositoryNames.addAll(GitHubAppInstallationsService.getRepositoriesForInstallation(id, appId, githubAppClient, gitHubInstallationIndex));
        }
        return (String[])repositoryNames.toArray(String[]::new);
    }

    private static List<String> getRepositoriesForInstallation(long installationId, String appId, GitHubAppClient githubAppClient, GitHubInstallationIndex gitHubInstallationIndex) throws ServiceCallException, StorageException {
        try {
            ImmutableList repositories = githubAppClient.getInstallationRepositories(installationId).getRepositories();
            return CollectionUtils.map((Collection)repositories, repository -> repository.getOwner() + "/" + repository.getName());
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == 403 && e.getMessage().contains("suspended")) {
                return List.of(GitHubAppInstallationsService.createMessageForSuspendedOrDeletedInstallation(appId, installationId, gitHubInstallationIndex, e, "suspended"));
            }
            if (e.getStatusCode() == 404) {
                return List.of(GitHubAppInstallationsService.createMessageForSuspendedOrDeletedInstallation(appId, installationId, gitHubInstallationIndex, e, "deleted"));
            }
            throw e;
        }
    }

    private static String createMessageForSuspendedOrDeletedInstallation(String appId, long installationId, GitHubInstallationIndex gitHubInstallationIndex, ServiceCallException e, String suspendedOrDeleted) throws StorageException {
        LOGGER.error("Installation '{}' of app '{}' has been {}.", (Object)installationId, (Object)appId, (Object)suspendedOrDeleted, (Object)e);
        Optional organization = gitHubInstallationIndex.getOrganizationByInstallation(Long.valueOf(installationId));
        return (String)((Object)organization.orElse("'" + installationId + "'")) + " (installation " + suspendedOrDeleted + ")";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

