/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.google.common.collect.Lists;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.AffectedFilesUtils;
import com.teamscale.index.findings.calculation.TokenElementChurnInfo;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/issues/{issueId}/affected-files")
public class IssueAffectedFilesService
extends ApiBase {
    private static final int AFFECTED_FILES_BATCH_SIZE = 1000;

    @GET
    @Operation(summary="Get files affected by issue", description="Retrieves the files affected by the commits to a given issue.", tags={"Issues"}, responses={@ApiResponse(responseCode="404", description="The issue identified by given ID could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<TokenElementChurnWithOriginInfo> getIssueAffectedFiles(@Parameter(description="ID of the issue to retrieve affected files for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\".", schema=@Schema(type="string")) @PathParam(value="issueId") TeamscaleIssueId issueId) throws StorageException {
        IssueIndex issueIndex = this.openProjectIndex(IssueIndex.class, null);
        TeamscaleIssue issue = issueIndex.getIssue(issueId);
        if (issue == null) {
            throw new NotFoundException("No such issue: " + String.valueOf(issueId));
        }
        return this.augmentWithFileInformation(AffectedFilesUtils.getAffectedFilesForIssue((TeamscaleIssueId)issueId, (ProjectStorageSystem)this.getProjectStorageSystem()));
    }

    private List<TokenElementChurnWithOriginInfo> augmentWithFileInformation(List<TokenElementChurnWithOriginInfo> entries) throws StorageException {
        ArrayList<TokenElementChurnWithOriginInfo> result = new ArrayList<TokenElementChurnWithOriginInfo>();
        if (entries.isEmpty()) {
            return result;
        }
        Map<String, List<TokenElementChurnWithOriginInfo>> branchToEntries = entries.stream().collect(Collectors.groupingBy(e -> e.getCommit().getBranchName()));
        for (Map.Entry<String, List<TokenElementChurnWithOriginInfo>> branchAndEntries : branchToEntries.entrySet()) {
            String branchName = branchAndEntries.getKey();
            TokenElementIndex tokenElementIndex = TokenElementIndex.open((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)HistoryAccessOption.readHead((String)branchName));
            List elementHistoryEntriesList = Lists.partition(branchAndEntries.getValue(), (int)1000);
            for (List elementHistoryEntries : elementHistoryEntriesList) {
                IssueAffectedFilesService.processTokenElementChurnWithOriginInfoBatch(branchName, elementHistoryEntries, tokenElementIndex, result);
            }
        }
        result.sort(TokenElementChurnWithOriginInfo.PATH_COMPARATOR);
        return result;
    }

    private static void processTokenElementChurnWithOriginInfoBatch(String branchName, List<TokenElementChurnWithOriginInfo> elementHistoryEntries, TokenElementIndex tokenElementIndex, List<TokenElementChurnWithOriginInfo> result) throws StorageException {
        List tokenElementInfos = tokenElementIndex.getTokenElements(CollectionUtils.map(elementHistoryEntries, TokenElementChurnInfo::getUniformPath));
        CollectionUtils.forEach(elementHistoryEntries, (Iterable)tokenElementInfos, (entry, tokenElementInfo) -> {
            if (tokenElementInfo == null) {
                result.add((TokenElementChurnWithOriginInfo)entry);
            } else {
                CommitDescriptor commitToOpenAt = CommitDescriptor.latestOnBranch((String)branchName);
                result.add(new TokenElementChurnWithOriginInfo(entry.getCommit(), commitToOpenAt, entry.getIntroductionCommit(), entry.getUniformPath(), entry.getChangeType(), entry.getChangeEntryOrigin(), entry.getOriginPath(), entry.getOriginCommit()));
            }
        });
    }
}

