/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.license;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.usage_data.CommitterDataCollector;
import com.teamscale.index.usage_data.CommitterDisplayName;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/license/active-committer-names")
public class CommitterNamesService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_USER_STATISTICS})
    @Operation(summary="Returns active committers across all projects", tags={"License"}, description="Returns all committers of the last n days (across all projects) that contribute to the license volume")
    public List<CommitterDisplayName> getListOfActiveCommitters(@Parameter(description="Number of days") @QueryParam(value="number-of-days") @DefaultValue(value="90") int numberOfDays) throws StorageException {
        CommitterNamesService.checkParameter(numberOfDays);
        CommitterDataCollector committerDataCollector = new CommitterDataCollector(this.serviceInfo.getIndexLayer());
        return committerDataCollector.collectCommitterNamesForLastNumberOfDays((Set)CollectionUtils.emptySet(), numberOfDays);
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_USER_STATISTICS})
    @Operation(summary="Returns active committers for the given primary project IDs", tags={"License"}, description="For the given list of primary project IDs, returns all committers of the last n days that contribute to the license volume. If an empty list is provided, all projects will be included (which is equivalent to performing a GET query).")
    public List<CommitterDisplayName> getListOfActiveCommittersForProjects(@RequestBody(required=true) Set<String> projectIds, @Parameter(description="Number of days") @QueryParam(value="number-of-days") @DefaultValue(value="90") int numberOfDays) throws StorageException {
        CommitterNamesService.checkParameter(numberOfDays);
        CommitterDataCollector committerDataCollector = new CommitterDataCollector(this.serviceInfo.getIndexLayer());
        return committerDataCollector.collectCommitterNamesForLastNumberOfDays(projectIds, numberOfDays);
    }

    private static void checkParameter(int numberOfDays) {
        if (numberOfDays < 0) {
            throw new BadRequestException("Number of days cannot be negative.");
        }
    }
}

