/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

public interface IGlobalLogServiceApi<SHORT_LOG extends ShortLogEntryBase, DETAIL_LOG extends DetailedLogEntryBase> {
    public static final String DELETE_LOG_ENTRIES_DESCRIPTION = "Deletes all log entries that match the applied filters.";

    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    @GET
    public ShortLogResponse<SHORT_LOG> getAllShortLogs(@BeanParam LogFilteringParameters var1) throws StorageException;

    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    @GET
    @Path(value="details/{id}")
    public DETAIL_LOG getDetailedLog(@PathParam(value="id") @Parameter(description="The identifier of the log entry") LogEntryIdentifier var1) throws StorageException;

    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    @GET
    @Path(value="frequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies() throws StorageException;

    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    @GET
    @Produces(value={"text/plain"})
    @Path(value="download")
    public Response downloadLog(@BeanParam LogFilteringParameters var1, @QueryParam(value="maxChars") @DefaultValue(value="0") int var2) throws StorageException;

    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @DELETE
    public void deleteLogEntries(@BeanParam LogFilteringParameters var1) throws StorageException;
}

