/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.merge_request.voting.VotingRecordIndex;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.PrintWriter;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/merge-requests/debug/voting-records")
public class DebugVotingRecordsDumpService
extends DebugDumpServiceBase {
    @GET
    @Operation(summary="Get voting records", description="Returns the voting records for a project.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getVotingRecords() throws StorageException {
        return this.getDebugDumpResults();
    }

    @Override
    protected void generateDump(PrintWriter writer) throws StorageException {
        VotingRecordIndex votingRecordIndex = this.openProjectIndex(VotingRecordIndex.class, null);
        PairList allRecordings = votingRecordIndex.getAllRecords();
        allRecordings.forEach(entry -> {
            writer.print(((CommitDescriptor)entry.getFirst()).toString());
            writer.print(": ");
            writer.println(entry.toString());
        });
    }
}

