/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/merge-requests/debug")
public class MergeRequestIndexDebugDumpService
extends ApiBase {
    private static final String CSV_COLUMNS = "id,title,url,status,source_branch,source_head,target_branch";

    @GET
    @Operation(summary="Prints the contents of the merge request index as CSV.", description="Prints the contents of the merge request index as CSV (id,title,url,status,source_branch,source_head,target_branch).", tags={"Debugging", "Merge Requests"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String printMergeRequestIndexContents() throws StorageException {
        MergeRequestIndex mergeRequestIndex = (MergeRequestIndex)this.getProjectStorageSystem().openProjectIndex(MergeRequestIndex.class, null);
        StringBuilder builder = new StringBuilder();
        builder.append(CSV_COLUMNS);
        for (MergeRequest mergeRequest : mergeRequestIndex.getAllMergeRequests()) {
            builder.append("\n").append(mergeRequest.getId()).append(",").append(mergeRequest.getTitle()).append(",").append(mergeRequest.getUrl()).append(",").append(mergeRequest.status).append(",").append(mergeRequest.getSourceBranch()).append(",").append(mergeRequest.sourceHead).append(",").append(mergeRequest.targetBranch);
        }
        return builder.toString();
    }
}

